/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.validation.patch;

import com.sap.scimono.callback.schemas.SchemasCallback;
import com.sap.scimono.entity.patch.PatchOperation;
import com.sap.scimono.entity.validation.Validator;
import com.sap.scimono.entity.validation.patch.PatchValidationException;
import com.sap.scimono.exception.SCIMException;
import com.sap.scimono.helper.Strings;

public class PathAttributeExistenceValidator
implements Validator<PatchOperation> {
    private SchemasCallback schemaAPI;

    public PathAttributeExistenceValidator(SchemasCallback schemaAPI) {
        this.schemaAPI = schemaAPI;
    }

    @Override
    public void validate(PatchOperation operation) {
        String path = operation.getPath();
        if (!this.isValidFullAttributeNotation(path) && this.schemaAPI.getCustomSchema(path) == null) {
            throw new PatchValidationException(SCIMException.Type.INVALID_PATH, String.format("Attribute with name '%s' does not exist", path));
        }
    }

    private boolean isValidFullAttributeNotation(String fullAttrNotation) {
        String schemaId = this.schemaAPI.getSchemaIdFromAttributeNotation(fullAttrNotation);
        if (Strings.isNullOrEmpty(schemaId)) {
            return false;
        }
        return !this.schemaAPI.getComplexAttributePath(fullAttrNotation).isEmpty();
    }
}

