/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.helper;

import com.sap.scimono.callback.schemas.SchemasCallback;
import com.sap.scimono.entity.EnterpriseExtension;
import com.sap.scimono.entity.Resource;
import com.sap.scimono.entity.base.Extension;
import com.sap.scimono.entity.schema.Attribute;
import com.sap.scimono.entity.schema.AttributeDataType;
import com.sap.scimono.entity.schema.Schema;
import com.sap.scimono.exception.SCIMException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;

public class ReadOnlyAttributesCleaner<T extends Resource<T>> {
    private SchemasCallback schemaAPI;

    public ReadOnlyAttributesCleaner(SchemasCallback schemaAPI) {
        this.schemaAPI = schemaAPI;
    }

    public T cleanCustomExtensions(T resource) {
        List<Extension> extensions = ((Resource)resource).getExtensions().values().stream().map(extension -> {
            if (extension instanceof EnterpriseExtension) {
                return extension;
            }
            Map<String, Object> attributes = extension.getAttributes();
            Schema customSchema = this.schemaAPI.getSchema(extension.getUrn());
            if (customSchema == null) {
                throw new SCIMException(SCIMException.Type.INVALID_SYNTAX, String.format("Schema '%s' does not exist.", extension.getUrn()), Response.Status.BAD_REQUEST);
            }
            this.removeReadOnlyAttributes(customSchema.toAttribute(), attributes);
            return new Extension.Builder((Extension)extension).setAttributes(attributes).build();
        }).collect(Collectors.toList());
        return (T)((Resource)((Resource)resource).builder().removeExtensions().addExtensions(extensions).build());
    }

    private boolean removeReadOnlyAttributes(Attribute targetAttribute, Object value) {
        if ("readOnly".equals(targetAttribute.getMutability())) {
            return true;
        }
        if (!AttributeDataType.COMPLEX.toString().equals(targetAttribute.getType())) {
            return false;
        }
        if (targetAttribute.isMultiValued()) {
            if (value instanceof Collection) {
                Collection valueCollection = (Collection)value;
                Attribute singleValuedAttribute = new Attribute.Builder().name(targetAttribute.getName()).multiValued(false).type(targetAttribute.getType()).mutability(targetAttribute.getMutability()).addSubAttributes(targetAttribute.getSubAttributes()).build();
                valueCollection.removeAll(valueCollection.stream().filter(object -> this.removeReadOnlyAttributes(singleValuedAttribute, object)).collect(Collectors.toList()));
            } else {
                throw new SCIMException(SCIMException.Type.INVALID_SYNTAX, String.format("Provided attribute with name '%s' is array according to the schema", targetAttribute.getName()), Response.Status.BAD_REQUEST);
            }
        }
        if (value instanceof Map) {
            Map valueMap = (Map)value;
            for (Map.Entry entry : valueMap.entrySet()) {
                Attribute subAttribute = targetAttribute.getSubAttributes().stream().filter(attribute -> ((String)entry.getKey()).equalsIgnoreCase(attribute.getName())).findAny().orElseThrow(() -> new SCIMException(SCIMException.Type.INVALID_SYNTAX, String.format("Provided attribute with name '%s' does not exist according to the schema", entry.getKey()), Response.Status.BAD_REQUEST));
                if (!this.removeReadOnlyAttributes(subAttribute, entry.getValue())) continue;
                valueMap.remove(entry.getKey());
            }
        }
        return false;
    }
}

