/*
 * Decompiled with CFR 0.152.
 */
package com.sappenin.objectify.translate;

import com.google.appengine.api.datastore.EmbeddedEntity;
import com.google.appengine.api.datastore.PropertyContainer;
import com.googlecode.objectify.impl.Path;
import com.googlecode.objectify.impl.TypeUtils;
import com.googlecode.objectify.impl.translate.CreateContext;
import com.googlecode.objectify.impl.translate.LoadContext;
import com.googlecode.objectify.impl.translate.NullSafeTranslator;
import com.googlecode.objectify.impl.translate.SaveContext;
import com.googlecode.objectify.impl.translate.SkipException;
import com.googlecode.objectify.impl.translate.Translator;
import com.googlecode.objectify.impl.translate.TranslatorFactory;
import com.googlecode.objectify.impl.translate.TypeKey;
import com.googlecode.objectify.repackaged.gentyref.GenericTypeReflector;
import com.googlecode.objectify.util.DatastoreUtils;
import com.googlecode.objectify.util.GenericUtils;
import com.sappenin.objectify.annotation.BigDecimal;
import com.sappenin.objectify.translate.util.BigDecimalCodec;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

public class BigDecimalEmbeddedEntityTranslatorFactory
implements TranslatorFactory<java.math.BigDecimal, EmbeddedEntity> {
    public Translator<java.math.BigDecimal, EmbeddedEntity> create(TypeKey<java.math.BigDecimal> tk, CreateContext ctx, Path path) {
        if (java.math.BigDecimal.class.isAssignableFrom(GenericTypeReflector.erase((Type)tk.getType()))) {
            return new BigDecimalTranslator(tk, ctx, path);
        }
        return null;
    }

    static class BigDecimalTranslator
    extends NullSafeTranslator<java.math.BigDecimal, EmbeddedEntity> {
        private final Translator<Object, Object> componentTranslator;
        private boolean storeDisplayableAmount;
        private boolean indexDisplayableAmount;
        private boolean indexAmount;
        private String encodedAmountFieldName = "encodedAmount";
        private String displayableAmountFieldName = "displayableAmount";

        public BigDecimalTranslator(TypeKey<java.math.BigDecimal> tk, CreateContext ctx, Path path) {
            BigDecimal bigDecimalAnnotation = (BigDecimal)TypeUtils.getAnnotation((Annotation[])tk.getAnnotations(), BigDecimal.class);
            Type componentType = GenericUtils.getMapValueType((Type)tk.getType());
            this.componentTranslator = ctx.getFactory().getTranslators().get(new TypeKey(componentType, tk), ctx, path);
            if (bigDecimalAnnotation != null) {
                this.storeDisplayableAmount = bigDecimalAnnotation.storeDisplayableAmount();
                this.indexAmount = bigDecimalAnnotation.indexEncodedAmount();
                this.indexDisplayableAmount = bigDecimalAnnotation.indexDisplayableAmount();
                this.encodedAmountFieldName = bigDecimalAnnotation.encodedAmountFieldName();
                this.displayableAmountFieldName = bigDecimalAnnotation.displayableAmountFieldName();
            }
        }

        protected java.math.BigDecimal loadSafe(EmbeddedEntity node, LoadContext ctx, Path path) throws SkipException {
            Object encodedAmountFieldValue;
            java.math.BigDecimal returnable = null;
            if (node.hasProperty(this.encodedAmountFieldName) && (encodedAmountFieldValue = node.getProperty(this.encodedAmountFieldName)) != null && encodedAmountFieldValue.toString().length() > 0) {
                java.math.BigDecimal bdValue = null;
                try {
                    bdValue = BigDecimalCodec.decodeAsBigDecimal(encodedAmountFieldValue.toString());
                }
                catch (Exception e) {
                    System.err.print("Unable to Decode java.math.BigDecimal from encoded string \"" + encodedAmountFieldValue + "\"");
                    e.printStackTrace();
                }
                returnable = bdValue;
            }
            return returnable;
        }

        protected EmbeddedEntity saveSafe(java.math.BigDecimal pojo, boolean index, SaveContext ctx, Path path) throws SkipException {
            if (pojo == null) {
                throw new SkipException();
            }
            EmbeddedEntity emb = new EmbeddedEntity();
            String encodedAmountValue = BigDecimalCodec.encode(pojo);
            Path propPath = path.extend(this.encodedAmountFieldName);
            Object value = this.componentTranslator.save((Object)encodedAmountValue, this.indexAmount, ctx, propPath);
            DatastoreUtils.setContainerProperty((PropertyContainer)emb, (String)this.encodedAmountFieldName, (Object)value, (boolean)this.indexAmount, (SaveContext)ctx, (Path)propPath);
            if (this.storeDisplayableAmount) {
                String displayableValue = pojo.toString();
                propPath = path.extend(this.displayableAmountFieldName);
                value = this.componentTranslator.save((Object)displayableValue, this.indexDisplayableAmount, ctx, propPath);
                DatastoreUtils.setContainerProperty((PropertyContainer)emb, (String)this.displayableAmountFieldName, (Object)value, (boolean)this.indexDisplayableAmount, (SaveContext)ctx, (Path)propPath);
            }
            return emb;
        }
    }
}

