/*
 * Decompiled with CFR 0.152.
 */
package com.sappenin.objectify.translate;

import com.google.appengine.api.datastore.EmbeddedEntity;
import com.google.appengine.api.datastore.PropertyContainer;
import com.googlecode.objectify.impl.Path;
import com.googlecode.objectify.impl.TypeUtils;
import com.googlecode.objectify.impl.translate.CreateContext;
import com.googlecode.objectify.impl.translate.LoadContext;
import com.googlecode.objectify.impl.translate.NullSafeTranslator;
import com.googlecode.objectify.impl.translate.SaveContext;
import com.googlecode.objectify.impl.translate.SkipException;
import com.googlecode.objectify.impl.translate.Translator;
import com.googlecode.objectify.impl.translate.TranslatorFactory;
import com.googlecode.objectify.impl.translate.TypeKey;
import com.googlecode.objectify.repackaged.gentyref.GenericTypeReflector;
import com.googlecode.objectify.util.DatastoreUtils;
import com.googlecode.objectify.util.GenericUtils;
import com.sappenin.objectify.translate.util.BigDecimalCodec;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import org.joda.money.BigMoney;
import org.joda.money.BigMoneyProvider;
import org.joda.money.CurrencyUnit;
import org.joda.money.Money;

public class JodaMoneyEmbeddedEntityTranslatorFactory
implements TranslatorFactory<BigMoneyProvider, EmbeddedEntity> {
    public Translator create(TypeKey tk, CreateContext ctx, Path path) {
        Class clazz = GenericTypeReflector.erase((Type)tk.getTypeAsClass());
        if (BigMoney.class.isAssignableFrom(clazz)) {
            return new JodaMoneyTranslator(tk, ctx, path, true);
        }
        if (Money.class.isAssignableFrom(clazz)) {
            return new JodaMoneyTranslator(tk, ctx, path, false);
        }
        return null;
    }

    static class JodaMoneyTranslator
    extends NullSafeTranslator<BigMoneyProvider, EmbeddedEntity> {
        private final Translator<Object, Object> componentTranslator;
        private boolean isBigMoney = false;
        private String encodedAmountFieldName = "encodedAmount";
        private String displayableAmountFieldName = "displayableAmount";
        private String currencyCodeFieldName = "currencyCode";
        private boolean storeDisplayableAmount;
        private boolean indexDisplayableAmount;
        private boolean indexAmount;
        private boolean indexCurrencyCode;

        public JodaMoneyTranslator(TypeKey tk, CreateContext ctx, Path path, boolean isBigMoney) {
            Type componentType = GenericUtils.getMapValueType((Type)tk.getType());
            this.componentTranslator = ctx.getFactory().getTranslators().get(new TypeKey(componentType, tk), ctx, path);
            this.isBigMoney = isBigMoney;
            com.sappenin.objectify.annotation.Money moneyAnnotation = (com.sappenin.objectify.annotation.Money)TypeUtils.getAnnotation((Annotation[])tk.getAnnotations(), com.sappenin.objectify.annotation.Money.class);
            if (moneyAnnotation != null) {
                this.storeDisplayableAmount = moneyAnnotation.storeDisplayableAmount();
                this.indexCurrencyCode = moneyAnnotation.indexCurrencyCode();
                this.indexAmount = moneyAnnotation.indexEncodedAmount();
                this.indexDisplayableAmount = moneyAnnotation.indexDisplayableAmount();
                this.encodedAmountFieldName = moneyAnnotation.encodedAmountFieldName();
                this.displayableAmountFieldName = moneyAnnotation.displayableAmountFieldName();
                this.currencyCodeFieldName = moneyAnnotation.currencyCodeFieldName();
            }
        }

        protected BigMoneyProvider loadSafe(EmbeddedEntity node, LoadContext ctx, Path path) throws SkipException {
            Object returnable = null;
            if (node.hasProperty(this.encodedAmountFieldName)) {
                Object currencyCodeFieldValue;
                BigDecimal bdValue = null;
                CurrencyUnit currencyUnit = CurrencyUnit.USD;
                Object encodedAmountFieldValue = node.getProperty(this.encodedAmountFieldName);
                if (encodedAmountFieldValue != null && encodedAmountFieldValue.toString().length() > 0) {
                    try {
                        bdValue = BigDecimalCodec.decodeAsBigDecimal(encodedAmountFieldValue.toString());
                    }
                    catch (Exception e) {
                        System.err.print("Unable to Decode java.math.BigDecimal from encoded string \"" + encodedAmountFieldValue + "\"");
                        e.printStackTrace();
                    }
                }
                if ((currencyCodeFieldValue = node.getProperty(this.currencyCodeFieldName)) != null && currencyCodeFieldValue.toString().length() > 0) {
                    currencyUnit = CurrencyUnit.getInstance((String)currencyCodeFieldValue.toString());
                }
                returnable = this.isBigMoney ? BigMoney.of((CurrencyUnit)currencyUnit, (BigDecimal)bdValue) : Money.of((CurrencyUnit)currencyUnit, (BigDecimal)bdValue);
            }
            return returnable;
        }

        protected EmbeddedEntity saveSafe(BigMoneyProvider pojo, boolean index, SaveContext ctx, Path path) throws SkipException {
            if (pojo == null) {
                throw new SkipException();
            }
            EmbeddedEntity emb = new EmbeddedEntity();
            BigMoney bigMoney = pojo.toBigMoney();
            String encodedAmountValue = BigDecimalCodec.encode(bigMoney.getAmount());
            Path propPath = path.extend(this.encodedAmountFieldName);
            Object value = this.componentTranslator.save((Object)encodedAmountValue, this.indexAmount, ctx, propPath);
            DatastoreUtils.setContainerProperty((PropertyContainer)emb, (String)this.encodedAmountFieldName, (Object)value, (boolean)this.indexAmount, (SaveContext)ctx, (Path)propPath);
            String currencyCodeValue = bigMoney.getCurrencyUnit().getCurrencyCode();
            propPath = path.extend(this.currencyCodeFieldName);
            value = this.componentTranslator.save((Object)currencyCodeValue, this.indexCurrencyCode, ctx, propPath);
            DatastoreUtils.setContainerProperty((PropertyContainer)emb, (String)this.currencyCodeFieldName, (Object)value, (boolean)this.indexCurrencyCode, (SaveContext)ctx, (Path)propPath);
            if (this.storeDisplayableAmount) {
                String displayableValue = bigMoney.toString();
                propPath = path.extend(this.displayableAmountFieldName);
                value = this.componentTranslator.save((Object)displayableValue, this.indexDisplayableAmount, ctx, propPath);
                DatastoreUtils.setContainerProperty((PropertyContainer)emb, (String)this.displayableAmountFieldName, (Object)value, (boolean)this.indexDisplayableAmount, (SaveContext)ctx, (Path)propPath);
            }
            return emb;
        }
    }
}

