/*
 * Decompiled with CFR 0.152.
 */
package com.sappenin.objectify.translate.util;

import java.math.BigDecimal;
import java.text.ParseException;

public class BigDecimalCodec {
    public static final String decode(String input) {
        try {
            if (input == null) {
                return null;
            }
            if (input.length() <= 0) {
                return "";
            }
            return new Decoder(input)._output;
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to decode number:" + input, e);
        }
    }

    public static final BigDecimal decodeAsBigDecimal(String input) {
        try {
            if (input == null) {
                return null;
            }
            if (input.length() <= 0) {
                throw new RuntimeException("Internal Error: Cannot decode an empty String");
            }
            return new BigDecimal(new Decoder(input)._output);
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to decode number:" + input, e);
        }
    }

    public static final String encode(String input) {
        try {
            if (input == null) {
                return null;
            }
            if (input.length() <= 0) {
                return "";
            }
            return new Encoder(input)._output;
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to parse number:" + input, e);
        }
    }

    public static final String encode(BigDecimal decimal) {
        if (decimal == null) {
            return null;
        }
        return BigDecimalCodec.encode(decimal.toPlainString());
    }

    public static class Decoder {
        private String _input;
        private int _position = 0;
        private int _end;
        private String _output = "";
        private boolean _isNegative = false;

        private Decoder(String input) throws ParseException {
            this._input = input;
            this._end = this._input.length();
            char lastChar = this._input.charAt(this._end - 1);
            while (lastChar == '*' || lastChar == '?' || lastChar == ':' || lastChar == '.') {
                lastChar = this._input.charAt(--this._end - 1);
            }
            char c = this._input.charAt(this._position);
            if (c == '*') {
                this._output = this._output + '-';
                this._isNegative = true;
            } else if (c != '?') {
                throw new ParseException("All encoded numbers must begin with either '?' or '*'", this._position);
            }
            this.readSequence();
            if (this.readDecimalPoint()) {
                this.readNumber(this._end - this._position);
            }
        }

        private boolean readDecimalPoint() throws ParseException {
            char c;
            if (this._end <= this._position) {
                return false;
            }
            if ((c = this._input.charAt(this._position++)) != (this._isNegative ? (char)':' : '.')) {
                throw new ParseException("Expected decimal point", this._position);
            }
            if (this._end <= this._position) {
                return false;
            }
            this._output = this._output + '.';
            return true;
        }

        private void readSequence() throws ParseException {
            char c;
            int sequenceCount = 0;
            while ((c = this._input.charAt(this._position++)) == '*' || c == '?') {
                ++sequenceCount;
            }
            --this._position;
            this.readNumberSequence(sequenceCount);
        }

        private void readNumberSequence(int sequenceCount) {
            int prefixLength = 1;
            while (1 < sequenceCount--) {
                prefixLength = this.readPrefix(prefixLength);
            }
            this.readNumber(prefixLength);
        }

        private int readPrefix(int length) {
            String s;
            if (this._isNegative) {
                char[] cs = new char[length];
                int i = 0;
                while (0 < length--) {
                    cs[i++] = (char)(48 + (57 - this._input.charAt(this._position++)));
                }
                s = new String(cs);
            } else {
                s = this._input.substring(this._position, this._position + length);
                this._position += length;
            }
            return Integer.parseInt(s);
        }

        private void readNumber(int length) {
            if (this._isNegative) {
                while (0 < length--) {
                    this._output = this._output + (char)(48 + (57 - this._input.charAt(this._position++)));
                }
            } else {
                this._output = this._output + this._input.substring(this._position, this._position + length);
                this._position += length;
            }
        }
    }

    public static class Encoder {
        private String _input;
        private int _position = 0;
        private int _end;
        private String _output = "";
        private boolean _isNegative = false;

        private Encoder(String input) throws ParseException {
            this._input = input;
            this._end = this._input.length();
            char c = this._input.charAt(this._position);
            if (c == '-') {
                this._input.charAt(this._position++);
                this._isNegative = true;
            }
            this.readNumberBeforeDecimal();
            if (this.readDecimalPoint()) {
                this.readNumber(this._end - this._position);
            }
            this._output = this._output + (this._isNegative ? (char)'?' : '*');
        }

        private boolean readDecimalPoint() throws ParseException {
            char c;
            if (this._end <= this._position) {
                return false;
            }
            if ((c = this._input.charAt(this._position++)) != '.') {
                this.throwParseException("Expected decimal point");
            }
            if (this._end <= this._position) {
                return false;
            }
            this._output = this._output + (this._isNegative ? (char)':' : '.');
            return true;
        }

        private void readNumberBeforeDecimal() throws ParseException {
            String unaryPrefix;
            char[] buffer = new char[this._input.length()];
            int i = 0;
            while (this._end > this._position) {
                int c;
                if (48 <= (c = this._input.charAt(this._position++)) && c <= 57) {
                    buffer[i++] = (char)(this._isNegative ? 48 + (57 - c) : c);
                    continue;
                }
                if (c != 46) continue;
                --this._position;
                break;
            }
            String prefix = "";
            int l = i;
            String string = unaryPrefix = this._isNegative ? "*" : "?";
            while (1 < l) {
                unaryPrefix = unaryPrefix + (this._isNegative ? (char)'*' : '?');
                String s = Integer.toString(l);
                if (this._isNegative) {
                    char[] cs = s.toCharArray();
                    for (int j = 0; j < cs.length; ++j) {
                        cs[j] = (char)(105 - cs[j]);
                    }
                    s = new String(cs);
                }
                prefix = s + prefix;
                l = s.length();
            }
            this._output = this._output + unaryPrefix;
            this._output = this._output + prefix;
            this._output = this._output + new String(buffer, 0, i);
        }

        private void readNumber(int length) {
            if (this._isNegative) {
                while (0 < length--) {
                    this._output = this._output + (char)(48 + (57 - this._input.charAt(this._position++)));
                }
            } else {
                this._output = this._output + this._input.substring(this._position, this._position + length);
                this._position += length;
            }
        }

        private void throwParseException(String message) throws ParseException {
            throw new ParseException(message, this._position);
        }
    }
}

