/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.rest;

import com.saucelabs.rest.Call;
import com.trilead.ssh2.Connection;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import sun.misc.BASE64Encoder;

public class Credential {
    private final String username;
    private final String key;

    public Credential(String username, String key) {
        this.username = username;
        this.key = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credential(File propertyFile) throws IOException {
        Properties props = new Properties();
        FileInputStream in = new FileInputStream(propertyFile);
        try {
            props.load(in);
            this.username = props.getProperty("username");
            this.key = props.getProperty("key");
            if (this.username == null) {
                throw new IOException(propertyFile + " didn't contain the 'username' parameter");
            }
            if (this.key == null) {
                throw new IOException(propertyFile + " didn't contain the 'key' parameter");
            }
        }
        finally {
            in.close();
        }
    }

    public Credential() throws IOException {
        this(Credential.getDefaultCredentialFile());
    }

    public String getUsername() {
        return this.username;
    }

    public String getKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTo(File propertyFile) throws IOException {
        Properties props = new Properties();
        props.put("username", this.username);
        props.put("key", this.key);
        FileOutputStream out = new FileOutputStream(propertyFile);
        try {
            props.store(out, "Sauce OnDemand access credential");
        }
        finally {
            out.close();
        }
    }

    URL getRestURL(String suffix) throws IOException {
        return new URL("https://saucelabs.com/rest/" + this.username + "/" + suffix);
    }

    Call call(String suffix) throws IOException {
        HttpURLConnection con = (HttpURLConnection)this.getRestURL(suffix).openConnection();
        String userpassword = this.username + ":" + this.key;
        con.setRequestProperty("Authorization", "Basic " + new BASE64Encoder().encode(userpassword.getBytes()));
        return new Call(con);
    }

    void authenticate(Connection con) throws IOException {
        con.authenticateWithPassword(this.username, this.key);
    }

    public static File getDefaultCredentialFile() {
        return new File(new File(System.getProperty("user.home")), ".sauce-ondemand");
    }
}

