/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.rest;

import com.saucelabs.rest.CreateTunnelRequest;
import com.saucelabs.rest.CreateTunnelResponse;
import com.saucelabs.rest.Credential;
import com.saucelabs.rest.SauceTunnel;
import com.saucelabs.rest.StatusResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.introspect.VisibilityChecker;
import org.codehaus.jackson.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SauceTunnelFactory {
    final Credential credential;
    static final ObjectMapper MAPPER = new ObjectMapper();

    public SauceTunnelFactory(Credential credential) {
        this.credential = credential;
    }

    public SauceTunnelFactory() throws IOException {
        this(new Credential());
    }

    public SauceTunnel create(String ... domains) throws IOException {
        return this.create(Arrays.asList(domains));
    }

    public SauceTunnel create(Collection<String> domains) throws IOException {
        CreateTunnelResponse rsp = this.credential.call("tunnels").post(new CreateTunnelRequest(domains), CreateTunnelResponse.class);
        if (rsp.error != null) {
            throw new IOException("Failed to create a tunnel to " + domains + " " + rsp.error);
        }
        if (!rsp.ok) {
            throw new IOException("Failed to create a tunnel but for a no apparent reason. ???");
        }
        return new SauceTunnel(this, rsp.id);
    }

    public List<SauceTunnel> list() throws IOException {
        List<StatusResponse> raw = this.credential.call("tunnels").get(new TypeReference<List<StatusResponse>>(){});
        ArrayList<SauceTunnel> tunnels = new ArrayList<SauceTunnel>(raw.size());
        for (StatusResponse r : raw) {
            tunnels.add(new SauceTunnel(this, r));
        }
        return tunnels;
    }

    static {
        MAPPER.setVisibilityChecker((VisibilityChecker)new VisibilityChecker.Std(JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.ANY));
        MAPPER.getDeserializationConfig().set(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

