/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucebindings;

import com.deque.html.axecore.results.Results;
import com.deque.html.axecore.selenium.AxeBuilder;
import com.saucelabs.saucebindings.DataCenter;
import com.saucelabs.saucebindings.options.BaseConfigurations;
import com.saucelabs.saucebindings.options.SauceOptions;
import java.net.MalformedURLException;
import java.net.URL;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;

public class SauceSession {
    private DataCenter dataCenter = DataCenter.US_WEST;
    private final SauceOptions sauceOptions;
    private URL sauceUrl;
    private RemoteWebDriver driver;

    public SauceSession() {
        this(new SauceOptions());
    }

    public SauceSession(BaseConfigurations configs) {
        this(configs.build());
    }

    public SauceSession(SauceOptions options) {
        this.sauceOptions = options;
    }

    public RemoteWebDriver start() {
        this.driver = this.createRemoteWebDriver(this.getSauceUrl(), this.sauceOptions.toCapabilities());
        return this.driver;
    }

    public URL getSauceUrl() {
        if (this.sauceUrl != null) {
            return this.sauceUrl;
        }
        try {
            return new URL(this.dataCenter.getValue());
        }
        catch (MalformedURLException e) {
            throw new InvalidArgumentException("Invalid URL");
        }
    }

    protected RemoteWebDriver createRemoteWebDriver(URL url, MutableCapabilities capabilities) {
        return new RemoteWebDriver(url, (Capabilities)capabilities);
    }

    public Results getAccessibilityResults() {
        return this.getAccessibilityResults(true);
    }

    public Results getAccessibilityResults(boolean frames) {
        AxeBuilder axeBuilder = new AxeBuilder();
        if (!frames) {
            axeBuilder.disableIframeTesting();
        }
        return this.getAccessibilityResults(axeBuilder);
    }

    public Results getAccessibilityResults(AxeBuilder builder) {
        return builder.analyze((WebDriver)this.driver);
    }

    public void stop(Boolean passed) {
        String result = passed != false ? "passed" : "failed";
        this.stop(result);
    }

    public void stop(String result) {
        this.updateResult(result);
        this.stop();
    }

    private void updateResult(String result) {
        this.getDriver().executeScript("sauce:job-result=" + result, new Object[0]);
        if (this.driver != null) {
            String sauceReporter = String.format("SauceOnDemandSessionID=%s job-name=%s", this.driver.getSessionId(), this.sauceOptions.sauce().getName());
            String sauceTestLink = String.format("Test Job Link: https://app.saucelabs.com/tests/%s", this.driver.getSessionId());
            System.out.print(sauceReporter + "\n" + sauceTestLink + "\n");
        }
    }

    private void stop() {
        if (this.driver != null) {
            this.driver.quit();
        }
    }

    public DataCenter getDataCenter() {
        return this.dataCenter;
    }

    public void setDataCenter(DataCenter dataCenter) {
        this.dataCenter = dataCenter;
    }

    public SauceOptions getSauceOptions() {
        return this.sauceOptions;
    }

    public void setSauceUrl(URL sauceUrl) {
        this.sauceUrl = sauceUrl;
    }

    public RemoteWebDriver getDriver() {
        return this.driver;
    }
}

