/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucebindings.options;

import com.saucelabs.saucebindings.options.BaseOptions;
import com.saucelabs.saucebindings.options.InvalidSauceOptionsArgumentException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;

public class CapabilityManager {
    private final BaseOptions options;

    public CapabilityManager(BaseOptions options) {
        this.options = options;
    }

    public void addCapabilities() {
        this.options.getValidOptions().forEach(capability -> {
            Object value = this.getCapability((String)capability);
            if (value != null) {
                this.options.capabilities.setCapability(capability, value);
            }
        });
    }

    public void setCapability(String key, Object value) {
        try {
            Class<?> type = this.getField(this.options.getClass(), key).getType();
            String setter = "set" + key.substring(0, 1).toUpperCase() + key.substring(1);
            Method method = this.options.getClass().getMethod(setter, type);
            method.invoke((Object)this.options, value);
        }
        catch (NoSuchFieldException e) {
            throw new InvalidSauceOptionsArgumentException(key + " is not a valid configuration value");
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to set capability for " + key, e);
        }
    }

    public Object getCapability(String capability) {
        try {
            String getter = "get" + capability.substring(0, 1).toUpperCase() + capability.substring(1);
            Method method = this.options.getClass().getMethod(getter, new Class[0]);
            return method.invoke((Object)this.options, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to get capability for " + capability, e);
        }
    }

    public void validateCapability(String name, Set values, String value) {
        if (!values.contains(value)) {
            String message = value + " is not a valid " + name + ", please choose from: " + values;
            throw new InvalidSauceOptionsArgumentException(message);
        }
    }

    private Field getField(Class<?> optionsClass, String fieldName) throws NoSuchFieldException {
        try {
            return optionsClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class<?> superclass = optionsClass.getSuperclass();
            if (superclass == null) {
                throw e;
            }
            return this.getField(optionsClass.getSuperclass(), fieldName);
        }
    }
}

