/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucebindings.options;

import com.saucelabs.saucebindings.JobVisibility;
import com.saucelabs.saucebindings.Prerun;
import com.saucelabs.saucebindings.SystemManager;
import com.saucelabs.saucebindings.options.BaseOptions;
import com.saucelabs.saucebindings.options.CapabilityManager;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.MutableCapabilities;

public class SauceLabsOptions
extends BaseOptions {
    private Boolean avoidProxy = null;
    private String build;
    private Boolean capturePerformance = null;
    private String chromedriverVersion;
    private Integer commandTimeout = null;
    private Map<String, Object> customData = null;
    private Boolean extendedDebugging = null;
    private String geckodriverVersion;
    private String edgedriverVersion;
    private Integer idleTimeout = null;
    private String iedriverVersion;
    private Integer maxDuration = null;
    private String name;
    private String parentTunnel;
    private Map<Prerun, Object> prerun;
    private URL prerunUrl;
    private Integer priority = null;
    private JobVisibility jobVisibility;
    private Boolean recordLogs = null;
    private Boolean recordScreenshots = null;
    private Boolean recordVideo = null;
    private String screenResolution;
    private String seleniumVersion;
    private List<String> tags = null;
    private String timeZone;
    private String tunnelIdentifier;
    private Boolean videoUploadOnPass = null;
    public final List<String> validOptions = Arrays.asList("avoidProxy", "build", "capturePerformance", "chromedriverVersion", "commandTimeout", "customData", "extendedDebugging", "geckodriverVersion", "edgedriverVersion", "idleTimeout", "iedriverVersion", "jobVisibility", "maxDuration", "name", "parentTunnel", "prerun", "prerunUrl", "priority", "recordLogs", "recordScreenshots", "recordVideo", "screenResolution", "seleniumVersion", "tags", "timeZone", "tunnelIdentifier", "videoUploadOnPass");
    @Deprecated
    public static final Map<String, String> knownCITools = new HashMap<String, String>();

    public SauceLabsOptions() {
        this.capabilityManager = new CapabilityManager(this);
    }

    public MutableCapabilities toCapabilities() {
        Object prerunValue;
        Object customDataValue;
        this.capabilities.setCapability("username", this.getSauceUsername());
        this.capabilities.setCapability("accessKey", this.getSauceAccessKey());
        Object visibilityValue = this.capabilityManager.getCapability("jobVisibility");
        if (visibilityValue != null) {
            this.capabilities.setCapability("public", visibilityValue);
            this.setJobVisibility(null);
        }
        if ((customDataValue = this.capabilityManager.getCapability("customData")) != null) {
            this.capabilities.setCapability("custom-data", customDataValue);
            this.setCustomData(null);
        }
        if ((prerunValue = this.capabilityManager.getCapability("prerunUrl")) != null) {
            this.capabilities.setCapability("prerun", prerunValue);
            this.setPrerunUrl(null);
        }
        this.capabilityManager.addCapabilities();
        return this.capabilities;
    }

    @Override
    protected void setCapability(String key, Object value) {
        if ("jobVisibility".equals(key)) {
            this.capabilityManager.validateCapability("JobVisibility", JobVisibility.keys(), (String)value);
            this.setJobVisibility(JobVisibility.valueOf(JobVisibility.fromString((String)value)));
        } else if ("prerun".equals(key)) {
            HashMap<Prerun, Object> prerunMap = new HashMap<Prerun, Object>();
            ((Map)value).forEach((oldKey, val) -> {
                this.capabilityManager.validateCapability("Prerun", Prerun.keys(), (String)oldKey);
                String keyString = Prerun.fromString((String)oldKey);
                prerunMap.put(Prerun.valueOf(keyString), val);
            });
            this.setPrerun(prerunMap);
        } else {
            super.setCapability(key, value);
        }
    }

    public String getBuild() {
        if (this.build != null) {
            return this.build;
        }
        if (SystemManager.get(knownCITools.get("Jenkins")) != null) {
            return SystemManager.get("BUILD_NAME") + ": " + SystemManager.get("BUILD_NUMBER");
        }
        if (SystemManager.get(knownCITools.get("Bamboo")) != null) {
            return SystemManager.get("bamboo_shortJobName") + ": " + SystemManager.get("bamboo_buildNumber");
        }
        if (SystemManager.get(knownCITools.get("Travis")) != null) {
            return SystemManager.get("TRAVIS_JOB_NAME") + ": " + SystemManager.get("TRAVIS_JOB_NUMBER");
        }
        if (SystemManager.get(knownCITools.get("Circle")) != null) {
            return SystemManager.get("CIRCLE_JOB") + ": " + SystemManager.get("CIRCLE_BUILD_NUM");
        }
        if (SystemManager.get(knownCITools.get("GitLab")) != null) {
            return SystemManager.get("CI_JOB_NAME") + ": " + SystemManager.get("CI_JOB_ID");
        }
        if (SystemManager.get(knownCITools.get("TeamCity")) != null) {
            return SystemManager.get("TEAMCITY_PROJECT_NAME") + ": " + SystemManager.get("BUILD_NUMBER");
        }
        return "Build Time: " + System.currentTimeMillis();
    }

    @Deprecated
    public boolean isKnownCI() {
        return !knownCITools.keySet().stream().allMatch(key -> SystemManager.get(key) == null);
    }

    protected String getSauceUsername() {
        return SystemManager.get("SAUCE_USERNAME", "Sauce Username was not provided");
    }

    protected String getSauceAccessKey() {
        return SystemManager.get("SAUCE_ACCESS_KEY", "Sauce Access Key was not provided");
    }

    public SauceLabsOptions setAvoidProxy(Boolean avoidProxy) {
        this.avoidProxy = avoidProxy;
        return this;
    }

    public SauceLabsOptions setBuild(String build) {
        this.build = build;
        return this;
    }

    public SauceLabsOptions setCapturePerformance(Boolean capturePerformance) {
        this.capturePerformance = capturePerformance;
        return this;
    }

    public SauceLabsOptions setChromedriverVersion(String chromedriverVersion) {
        this.chromedriverVersion = chromedriverVersion;
        return this;
    }

    public SauceLabsOptions setCommandTimeout(Integer commandTimeout) {
        this.commandTimeout = commandTimeout;
        return this;
    }

    public SauceLabsOptions setCustomData(Map<String, Object> customData) {
        this.customData = customData;
        return this;
    }

    public SauceLabsOptions setExtendedDebugging(Boolean extendedDebugging) {
        this.extendedDebugging = extendedDebugging;
        return this;
    }

    public SauceLabsOptions setGeckodriverVersion(String geckodriverVersion) {
        this.geckodriverVersion = geckodriverVersion;
        return this;
    }

    public SauceLabsOptions setEdgedriverVersion(String edgedriverVersion) {
        this.edgedriverVersion = edgedriverVersion;
        return this;
    }

    public SauceLabsOptions setIdleTimeout(Integer idleTimeout) {
        this.idleTimeout = idleTimeout;
        return this;
    }

    public SauceLabsOptions setIedriverVersion(String iedriverVersion) {
        this.iedriverVersion = iedriverVersion;
        return this;
    }

    public SauceLabsOptions setMaxDuration(Integer maxDuration) {
        this.maxDuration = maxDuration;
        return this;
    }

    public SauceLabsOptions setName(String name) {
        this.name = name;
        return this;
    }

    public SauceLabsOptions setParentTunnel(String parentTunnel) {
        this.parentTunnel = parentTunnel;
        return this;
    }

    public SauceLabsOptions setPrerun(Map<Prerun, Object> prerun) {
        this.prerun = prerun;
        return this;
    }

    public SauceLabsOptions setPrerunUrl(URL prerunUrl) {
        this.prerunUrl = prerunUrl;
        return this;
    }

    public SauceLabsOptions setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public SauceLabsOptions setJobVisibility(JobVisibility jobVisibility) {
        this.jobVisibility = jobVisibility;
        return this;
    }

    public SauceLabsOptions setRecordLogs(Boolean recordLogs) {
        this.recordLogs = recordLogs;
        return this;
    }

    public SauceLabsOptions setRecordScreenshots(Boolean recordScreenshots) {
        this.recordScreenshots = recordScreenshots;
        return this;
    }

    public SauceLabsOptions setRecordVideo(Boolean recordVideo) {
        this.recordVideo = recordVideo;
        return this;
    }

    public SauceLabsOptions setScreenResolution(String screenResolution) {
        this.screenResolution = screenResolution;
        return this;
    }

    public SauceLabsOptions setSeleniumVersion(String seleniumVersion) {
        this.seleniumVersion = seleniumVersion;
        return this;
    }

    public SauceLabsOptions setTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public SauceLabsOptions setTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public SauceLabsOptions setTunnelIdentifier(String tunnelIdentifier) {
        this.tunnelIdentifier = tunnelIdentifier;
        return this;
    }

    public SauceLabsOptions setVideoUploadOnPass(Boolean videoUploadOnPass) {
        this.videoUploadOnPass = videoUploadOnPass;
        return this;
    }

    public Boolean getAvoidProxy() {
        return this.avoidProxy;
    }

    public Boolean getCapturePerformance() {
        return this.capturePerformance;
    }

    public String getChromedriverVersion() {
        return this.chromedriverVersion;
    }

    public Integer getCommandTimeout() {
        return this.commandTimeout;
    }

    public Map<String, Object> getCustomData() {
        return this.customData;
    }

    public Boolean getExtendedDebugging() {
        return this.extendedDebugging;
    }

    public String getGeckodriverVersion() {
        return this.geckodriverVersion;
    }

    public String getEdgedriverVersion() {
        return this.edgedriverVersion;
    }

    public Integer getIdleTimeout() {
        return this.idleTimeout;
    }

    public String getIedriverVersion() {
        return this.iedriverVersion;
    }

    public Integer getMaxDuration() {
        return this.maxDuration;
    }

    public String getName() {
        return this.name;
    }

    public String getParentTunnel() {
        return this.parentTunnel;
    }

    public Map<Prerun, Object> getPrerun() {
        return this.prerun;
    }

    public URL getPrerunUrl() {
        return this.prerunUrl;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public JobVisibility getJobVisibility() {
        return this.jobVisibility;
    }

    public Boolean getRecordLogs() {
        return this.recordLogs;
    }

    public Boolean getRecordScreenshots() {
        return this.recordScreenshots;
    }

    public Boolean getRecordVideo() {
        return this.recordVideo;
    }

    public String getScreenResolution() {
        return this.screenResolution;
    }

    public String getSeleniumVersion() {
        return this.seleniumVersion;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getTunnelIdentifier() {
        return this.tunnelIdentifier;
    }

    public Boolean getVideoUploadOnPass() {
        return this.videoUploadOnPass;
    }

    @Override
    public List<String> getValidOptions() {
        return this.validOptions;
    }

    static {
        knownCITools.put("Jenkins", "BUILD_TAG");
        knownCITools.put("Bamboo", "bamboo_agentId");
        knownCITools.put("Travis", "TRAVIS_JOB_ID");
        knownCITools.put("Circle", "CIRCLE_JOB");
        knownCITools.put("GitLab", "CI");
        knownCITools.put("TeamCity", "TEAMCITY_PROJECT_NAME");
    }
}

