/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucebindings.options;

import com.saucelabs.saucebindings.Browser;
import com.saucelabs.saucebindings.PageLoadStrategy;
import com.saucelabs.saucebindings.SaucePlatform;
import com.saucelabs.saucebindings.TimeoutStore;
import com.saucelabs.saucebindings.Timeouts;
import com.saucelabs.saucebindings.UnhandledPromptBehavior;
import com.saucelabs.saucebindings.options.BaseOptions;
import com.saucelabs.saucebindings.options.CapabilityManager;
import com.saucelabs.saucebindings.options.ChromeConfigurations;
import com.saucelabs.saucebindings.options.EdgeConfigurations;
import com.saucelabs.saucebindings.options.FirefoxConfigurations;
import com.saucelabs.saucebindings.options.InternetExplorerConfigurations;
import com.saucelabs.saucebindings.options.SafariConfigurations;
import com.saucelabs.saucebindings.options.SauceLabsOptions;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.safari.SafariOptions;

public class SauceOptions
extends BaseOptions {
    private SauceLabsOptions sauceLabsOptions = null;
    public TimeoutStore timeout = new TimeoutStore();
    protected Browser browserName = Browser.CHROME;
    protected String browserVersion = "latest";
    protected SaucePlatform platformName = SaucePlatform.WINDOWS_10;
    protected PageLoadStrategy pageLoadStrategy;
    protected Boolean acceptInsecureCerts = null;
    protected Proxy proxy;
    protected Boolean setWindowRect = null;
    protected Map<Timeouts, Integer> timeouts;
    protected Boolean strictFileInteractability = null;
    protected UnhandledPromptBehavior unhandledPromptBehavior;
    public final List<String> validOptions = Arrays.asList("browserName", "browserVersion", "platformName", "pageLoadStrategy", "acceptInsecureCerts", "proxy", "setWindowRect", "timeouts", "strictFileInteractability", "unhandledPromptBehavior");

    public static ChromeConfigurations chrome() {
        return SauceOptions.chrome(new ChromeOptions());
    }

    public static ChromeConfigurations chrome(ChromeOptions chromeOptions) {
        return new ChromeConfigurations(chromeOptions);
    }

    public static EdgeConfigurations edge() {
        return SauceOptions.edge(new EdgeOptions());
    }

    public static EdgeConfigurations edge(EdgeOptions edgeOptions) {
        return new EdgeConfigurations(edgeOptions);
    }

    public static FirefoxConfigurations firefox() {
        return SauceOptions.firefox(new FirefoxOptions());
    }

    public static FirefoxConfigurations firefox(FirefoxOptions firefoxOptions) {
        return new FirefoxConfigurations(firefoxOptions);
    }

    public static InternetExplorerConfigurations ie() {
        return SauceOptions.ie(new InternetExplorerOptions());
    }

    public static InternetExplorerConfigurations ie(InternetExplorerOptions internetExplorerOptions) {
        return new InternetExplorerConfigurations(internetExplorerOptions);
    }

    public static SafariConfigurations safari() {
        return SauceOptions.safari(new SafariOptions());
    }

    public static SafariConfigurations safari(SafariOptions safariOptions) {
        return new SafariConfigurations(safariOptions);
    }

    public SauceLabsOptions sauce() {
        return this.sauceLabsOptions;
    }

    public SauceOptions() {
        this(new MutableCapabilities());
    }

    public Map<Timeouts, Integer> getTimeouts() {
        if (this.timeout.getTimeouts().isEmpty()) {
            return this.timeouts;
        }
        return this.timeout.getTimeouts();
    }

    SauceOptions(MutableCapabilities options) {
        this.capabilities = new MutableCapabilities(options.asMap());
        this.capabilityManager = new CapabilityManager(this);
        this.sauceLabsOptions = new SauceLabsOptions();
        if (options.getCapability("browserName") != null) {
            this.setCapability("browserName", options.getCapability("browserName"));
        }
    }

    public MutableCapabilities toCapabilities() {
        this.capabilityManager.addCapabilities();
        this.capabilities.setCapability("sauce:options", (Object)this.sauce().toCapabilities());
        return this.capabilities;
    }

    @Override
    public void setCapability(String key, Object value) {
        switch (key) {
            case "browserName": {
                this.capabilityManager.validateCapability("Browser", Browser.keys(), (String)value);
                this.setBrowserName(Browser.valueOf(Browser.fromString((String)value)));
                break;
            }
            case "platformName": {
                this.capabilityManager.validateCapability("SaucePlatform", SaucePlatform.keys(), (String)value);
                this.setPlatformName(SaucePlatform.valueOf(SaucePlatform.fromString((String)value)));
                break;
            }
            case "pageLoadStrategy": {
                this.capabilityManager.validateCapability("PageLoadStrategy", PageLoadStrategy.keys(), (String)value);
                this.setPageLoadStrategy(PageLoadStrategy.valueOf(PageLoadStrategy.fromString((String)value)));
                break;
            }
            case "unhandledPromptBehavior": {
                this.capabilityManager.validateCapability("UnhandledPromptBehavior", UnhandledPromptBehavior.keys(), (String)value);
                this.setUnhandledPromptBehavior(UnhandledPromptBehavior.valueOf(UnhandledPromptBehavior.fromString((String)value)));
                break;
            }
            case "timeouts": {
                HashMap<Timeouts, Integer> timeoutsMap = new HashMap<Timeouts, Integer>();
                ((Map)value).forEach((oldKey, val) -> {
                    this.capabilityManager.validateCapability("Timeouts", Timeouts.keys(), (String)oldKey);
                    String keyString = Timeouts.fromString((String)oldKey);
                    timeoutsMap.put(Timeouts.valueOf(keyString), (Integer)val);
                });
                this.setTimeouts(timeoutsMap);
                break;
            }
            case "sauce": {
                this.sauce().mergeCapabilities((HashMap)value);
                break;
            }
            default: {
                if (this.sauce().getValidOptions().contains(key)) {
                    this.deprecatedSetCapability(key, value);
                    break;
                }
                super.setCapability(key, value);
            }
        }
    }

    public Duration getImplicitWaitTimeout() {
        return Duration.ofMillis(this.getTimeouts().get((Object)Timeouts.IMPLICIT).intValue());
    }

    public Duration getPageLoadTimeout() {
        return Duration.ofMillis(this.getTimeouts().get((Object)Timeouts.PAGE_LOAD).intValue());
    }

    public Duration getScriptTimeout() {
        return Duration.ofMillis(this.getTimeouts().get((Object)Timeouts.SCRIPT).intValue());
    }

    private void deprecatedSetCapability(String key, Object value) {
        System.out.println("WARNING: using merge() of Map with value of (" + key + ") is DEPRECATED");
        System.out.println("place this value inside a nested Map with the keyword 'sauce'");
        this.sauce().setCapability(key, value);
    }

    public SauceOptions setTimeout(TimeoutStore timeout) {
        this.timeout = timeout;
        return this;
    }

    public SauceOptions setBrowserName(Browser browserName) {
        this.browserName = browserName;
        return this;
    }

    public SauceOptions setBrowserVersion(String browserVersion) {
        this.browserVersion = browserVersion;
        return this;
    }

    public SauceOptions setPlatformName(SaucePlatform platformName) {
        this.platformName = platformName;
        return this;
    }

    public SauceOptions setPageLoadStrategy(PageLoadStrategy pageLoadStrategy) {
        this.pageLoadStrategy = pageLoadStrategy;
        return this;
    }

    public SauceOptions setAcceptInsecureCerts(Boolean acceptInsecureCerts) {
        this.acceptInsecureCerts = acceptInsecureCerts;
        return this;
    }

    public SauceOptions setProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public SauceOptions setSetWindowRect(Boolean setWindowRect) {
        this.setWindowRect = setWindowRect;
        return this;
    }

    public SauceOptions setTimeouts(Map<Timeouts, Integer> timeouts) {
        this.timeouts = timeouts;
        return this;
    }

    public SauceOptions setStrictFileInteractability(Boolean strictFileInteractability) {
        this.strictFileInteractability = strictFileInteractability;
        return this;
    }

    public SauceOptions setUnhandledPromptBehavior(UnhandledPromptBehavior unhandledPromptBehavior) {
        this.unhandledPromptBehavior = unhandledPromptBehavior;
        return this;
    }

    public TimeoutStore getTimeout() {
        return this.timeout;
    }

    public Browser getBrowserName() {
        return this.browserName;
    }

    public String getBrowserVersion() {
        return this.browserVersion;
    }

    public SaucePlatform getPlatformName() {
        return this.platformName;
    }

    public PageLoadStrategy getPageLoadStrategy() {
        return this.pageLoadStrategy;
    }

    public Boolean getAcceptInsecureCerts() {
        return this.acceptInsecureCerts;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public Boolean getSetWindowRect() {
        return this.setWindowRect;
    }

    public Boolean getStrictFileInteractability() {
        return this.strictFileInteractability;
    }

    public UnhandledPromptBehavior getUnhandledPromptBehavior() {
        return this.unhandledPromptBehavior;
    }

    @Override
    public List<String> getValidOptions() {
        return this.validOptions;
    }
}

