/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.junit;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerScheduler;
import org.junit.runners.model.Statement;

public class ConcurrentParameterized
extends Suite {
    private static final List<Runner> NO_RUNNERS = Collections.emptyList();
    private final ArrayList<Runner> runners = new ArrayList();

    public ConcurrentParameterized(Class<?> klass) throws Throwable {
        super(klass, NO_RUNNERS);
        Parameters parameters = (Parameters)this.getParametersMethod().getAnnotation(Parameters.class);
        this.createRunnersForParameters(this.allParameters(), parameters.name());
        this.setScheduler(new NonBlockingAsynchronousRunner());
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    private Iterable<Object[]> allParameters() throws Throwable {
        Object parameters = this.getParametersMethod().invokeExplosively(null, new Object[0]);
        if (parameters instanceof Iterable) {
            return (Iterable)parameters;
        }
        throw this.parametersMethodReturnedWrongType();
    }

    private FrameworkMethod getParametersMethod() throws Exception {
        List methods = this.getTestClass().getAnnotatedMethods(Parameters.class);
        for (FrameworkMethod each : methods) {
            if (!each.isStatic() || !each.isPublic()) continue;
            return each;
        }
        throw new Exception("No public static parameters method on class " + this.getTestClass().getName());
    }

    private void createRunnersForParameters(Iterable<Object[]> allParameters, String namePattern) throws InitializationError, Exception {
        try {
            int i = 0;
            for (Object[] parametersOfSingleTest : allParameters) {
                String name = this.nameFor(namePattern, i, parametersOfSingleTest);
                SauceClassRunnerForParameters runner = new SauceClassRunnerForParameters(this.getTestClass().getJavaClass(), parametersOfSingleTest, name);
                this.runners.add((Runner)runner);
                ++i;
            }
        }
        catch (ClassCastException e) {
            throw this.parametersMethodReturnedWrongType();
        }
    }

    private String nameFor(String namePattern, int index, Object[] parameters) {
        String finalPattern = namePattern.replaceAll("\\{index\\}", Integer.toString(index));
        String name = MessageFormat.format(finalPattern, parameters);
        return "[" + name + "]";
    }

    private Exception parametersMethodReturnedWrongType() throws Exception {
        String className = this.getTestClass().getName();
        String methodName = this.getParametersMethod().getName();
        String message = MessageFormat.format("{0}.{1}() must return an Iterable of arrays.", className, methodName);
        return new Exception(message);
    }

    private List<FrameworkField> getAnnotatedFieldsByParameter() {
        return this.getTestClass().getAnnotatedFields(Parameter.class);
    }

    private boolean fieldsAreAnnotated() {
        return !this.getAnnotatedFieldsByParameter().isEmpty();
    }

    private static class NonBlockingAsynchronousRunner
    implements RunnerScheduler {
        private final List<Future<Object>> futures = Collections.synchronizedList(new ArrayList());
        private final ExecutorService fService;

        public NonBlockingAsynchronousRunner() {
            String threads = System.getProperty("junit.parallel.threads", "16");
            int numThreads = Integer.parseInt(threads);
            this.fService = Executors.newFixedThreadPool(numThreads);
        }

        public void schedule(final Runnable childStatement) {
            Callable<Object> objectCallable = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    childStatement.run();
                    return null;
                }
            };
            this.futures.add(this.fService.submit(objectCallable));
        }

        public void finished() {
            this.waitForCompletion();
        }

        public void waitForCompletion() {
            for (Future<Object> each : this.futures) {
                try {
                    each.get();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class SauceClassRunnerForParameters
    extends BlockJUnit4ClassRunner {
        private final Object[] fParameters;
        private final String fName;
        private final RunnerScheduler scheduler;

        SauceClassRunnerForParameters(Class<?> type, Object[] parameters, String name) throws InitializationError {
            super(type);
            this.fParameters = parameters;
            this.fName = name;
            this.scheduler = new NonBlockingAsynchronousRunner();
        }

        public Object createTest() throws Exception {
            if (ConcurrentParameterized.this.fieldsAreAnnotated()) {
                return this.createTestUsingFieldInjection();
            }
            return this.createTestUsingConstructorInjection();
        }

        private Object createTestUsingConstructorInjection() throws Exception {
            return this.getTestClass().getOnlyConstructor().newInstance(this.fParameters);
        }

        private Object createTestUsingFieldInjection() throws Exception {
            List annotatedFieldsByParameter = ConcurrentParameterized.this.getAnnotatedFieldsByParameter();
            if (annotatedFieldsByParameter.size() != this.fParameters.length) {
                throw new Exception("Wrong number of parameters and @Parameter fields. @Parameter fields counted: " + annotatedFieldsByParameter.size() + ", available parameters: " + this.fParameters.length + ".");
            }
            Object testClassInstance = this.getTestClass().getJavaClass().newInstance();
            for (FrameworkField each : annotatedFieldsByParameter) {
                Field field = each.getField();
                Parameter annotation = field.getAnnotation(Parameter.class);
                int index = annotation.value();
                try {
                    field.set(testClassInstance, this.fParameters[index]);
                }
                catch (IllegalArgumentException iare) {
                    throw new Exception(this.getTestClass().getName() + ": Trying to set " + field.getName() + " with the value " + this.fParameters[index] + " that is not the right type (" + this.fParameters[index].getClass().getSimpleName() + " instead of " + field.getType().getSimpleName() + ").", iare);
                }
            }
            return testClassInstance;
        }

        protected String getName() {
            return this.fName;
        }

        protected String testName(FrameworkMethod method) {
            return method.getName() + this.getName();
        }

        protected void validateConstructor(List<Throwable> errors) {
            this.validateOnlyOneConstructor(errors);
            if (ConcurrentParameterized.this.fieldsAreAnnotated()) {
                this.validateZeroArgConstructor(errors);
            }
        }

        protected void validateFields(List<Throwable> errors) {
            super.validateFields(errors);
            if (ConcurrentParameterized.this.fieldsAreAnnotated()) {
                List annotatedFieldsByParameter = ConcurrentParameterized.this.getAnnotatedFieldsByParameter();
                int[] usedIndices = new int[annotatedFieldsByParameter.size()];
                for (FrameworkField each : annotatedFieldsByParameter) {
                    int index = each.getField().getAnnotation(Parameter.class).value();
                    if (index < 0 || index > annotatedFieldsByParameter.size() - 1) {
                        errors.add(new Exception("Invalid @Parameter value: " + index + ". @Parameter fields counted: " + annotatedFieldsByParameter.size() + ". Please use an index between 0 and " + (annotatedFieldsByParameter.size() - 1) + "."));
                        continue;
                    }
                    int n = index;
                    usedIndices[n] = usedIndices[n] + 1;
                }
                for (int index = 0; index < usedIndices.length; ++index) {
                    int numberOfUse = usedIndices[index];
                    if (numberOfUse == 0) {
                        errors.add(new Exception("@Parameter(" + index + ") is never used."));
                        continue;
                    }
                    if (numberOfUse <= 1) continue;
                    errors.add(new Exception("@Parameter(" + index + ") is used more than once (" + numberOfUse + ")."));
                }
            }
        }

        protected Statement classBlock(final RunNotifier notifier) {
            return new Statement(){

                public void evaluate() {
                    SauceClassRunnerForParameters.this.runChildren(notifier);
                }
            };
        }

        protected Annotation[] getRunnerAnnotations() {
            return new Annotation[0];
        }

        private void runChildren(final RunNotifier notifier) {
            for (final FrameworkMethod each : this.getChildren()) {
                this.scheduler.schedule(new Runnable(){

                    @Override
                    public void run() {
                        SauceClassRunnerForParameters.this.runChild(each, notifier);
                    }
                });
            }
            this.scheduler.finished();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Parameter {
        public int value() default 0;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Parameters {
        public String name() default "{index}";
    }
}

