/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucebindings.junit5;

import com.saucelabs.saucebindings.DataCenter;
import com.saucelabs.saucebindings.SauceSession;
import com.saucelabs.saucebindings.options.SauceOptions;
import java.util.Arrays;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.extension.TestWatcher;
import org.openqa.selenium.remote.RemoteWebDriver;

public class SauceBaseTest {
    protected RemoteWebDriver driver;
    protected SauceSession session;
    protected DataCenter dataCenter = DataCenter.US_WEST;
    @RegisterExtension
    public SauceTestWatcher watcher = new SauceTestWatcher();

    public SauceOptions createSauceOptions() {
        return new SauceOptions();
    }

    @BeforeEach
    public void setUp(TestInfo testinfo) {
        SauceOptions sauceOptions = this.createSauceOptions();
        if (sauceOptions.sauce().getName() == null) {
            sauceOptions.sauce().setName(testinfo.getDisplayName());
        }
        this.session = new SauceSession(sauceOptions);
        this.session.setDataCenter(this.getDataCenter());
        this.driver = this.session.start();
    }

    public DataCenter getDataCenter() {
        return this.dataCenter;
    }

    public class SauceTestWatcher
    implements TestWatcher {
        public void testSuccessful(ExtensionContext context) {
            SauceBaseTest.this.session.stop(Boolean.valueOf(true));
        }

        public void testFailed(ExtensionContext context, Throwable cause) {
            SauceBaseTest.this.driver.executeScript("sauce:context=Failure Reason: " + cause.getMessage(), new Object[0]);
            for (Object trace : Arrays.stream(cause.getStackTrace()).toArray()) {
                if (trace.toString().contains("sun")) break;
                SauceBaseTest.this.driver.executeScript("sauce:context=Backtrace: " + trace, new Object[0]);
            }
            SauceBaseTest.this.session.stop(Boolean.valueOf(false));
        }
    }
}

