/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest;

import com.saucelabs.saucerest.SecurityUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.UnexpectedException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.cookie.BestMatchSpecFactory;
import org.apache.http.impl.cookie.BrowserCompatSpec;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.simple.JSONValue;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SauceREST {
    private static final Logger logger = Logger.getLogger(SauceREST.class.getName());
    private static final long HTTP_READ_TIMEOUT_SECONDS = TimeUnit.SECONDS.toMillis(10L);
    private static final long HTTP_CONNECT_TIMEOUT_SECONDS = TimeUnit.SECONDS.toMillis(10L);
    protected String username;
    protected String accessKey;
    public static final String RESTURL = "https://saucelabs.com/rest/v1/%1$s";
    private static final String USER_RESULT_FORMAT = "https://saucelabs.com/rest/v1/%1$s/%2$s";
    private static final String JOB_RESULT_FORMAT = "https://saucelabs.com/rest/v1/%1$s/jobs/%2$s";
    private static final String STOP_JOB_FORMAT = "https://saucelabs.com/rest/v1/%1$s/jobs/%2$s/stop";
    private static final String DOWNLOAD_VIDEO_FORMAT = "https://saucelabs.com/rest/v1/%1$s/jobs/%2$s/assets/video.flv";
    private static final String DOWNLOAD_LOG_FORMAT = "https://saucelabs.com/rest/v1/%1$s/jobs/%2$s/assets/selenium-server.log";
    private static final String GET_TUNNEL_FORMAT = "https://saucelabs.com/rest/v1/%1$s/tunnels";
    private static final String DELETE_TUNNEL_FORMAT = "https://saucelabs.com/rest/v1/%1$s/tunnels/%2$s";
    private static final String DATE_FORMAT = "yyyyMMdd_HHmmSS";

    public SauceREST(String username, String accessKey) {
        this.username = username;
        this.accessKey = accessKey;
    }

    public void jobPassed(String jobId) {
        HashMap<String, Object> updates = new HashMap<String, Object>();
        updates.put("passed", true);
        this.updateJobInfo(jobId, updates);
    }

    public void jobFailed(String jobId) {
        HashMap<String, Object> updates = new HashMap<String, Object>();
        updates.put("passed", false);
        this.updateJobInfo(jobId, updates);
    }

    public void downloadVideo(String jobId, String location) {
        URL restEndpoint = null;
        try {
            restEndpoint = new URL(String.format(DOWNLOAD_VIDEO_FORMAT, this.username, jobId));
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "Error constructing Sauce URL", e);
        }
        this.downloadFile(jobId, location, restEndpoint);
    }

    public void downloadLog(String jobId, String location) {
        URL restEndpoint = null;
        try {
            restEndpoint = new URL(String.format(DOWNLOAD_LOG_FORMAT, this.username, jobId));
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "Error constructing Sauce URL", e);
        }
        this.downloadFile(jobId, location, restEndpoint);
    }

    public String retrieveResults(String path) {
        URL restEndpoint = null;
        try {
            restEndpoint = new URL(String.format(USER_RESULT_FORMAT, this.username, path));
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "Error constructing Sauce URL", e);
        }
        return this.retrieveResults(restEndpoint);
    }

    public String getJobInfo(String jobId) {
        URL restEndpoint = null;
        try {
            restEndpoint = new URL(String.format(JOB_RESULT_FORMAT, this.username, jobId));
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "Error constructing Sauce URL", e);
        }
        return this.retrieveResults(restEndpoint);
    }

    public String retrieveResults(URL restEndpoint) {
        BufferedReader reader = null;
        StringBuilder builder = new StringBuilder();
        try {
            String inputLine;
            HttpURLConnection connection = this.openConnection(restEndpoint);
            connection.setDoOutput(true);
            this.addAuthenticationProperty(connection);
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((inputLine = reader.readLine()) != null) {
                builder.append(inputLine);
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error retrieving Sauce Results", e);
        }
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error closing Sauce input stream", e);
        }
        return builder.toString();
    }

    private void downloadFile(String jobId, String location, URL restEndpoint) {
        try {
            int i;
            HttpURLConnection connection = this.openConnection(restEndpoint);
            connection.setDoOutput(true);
            connection.setRequestMethod("GET");
            this.addAuthenticationProperty(connection);
            InputStream stream = connection.getInputStream();
            BufferedInputStream in = new BufferedInputStream(stream);
            SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
            String saveName = jobId + format.format(new Date());
            saveName = restEndpoint.getPath().endsWith(".flv") ? saveName + ".flv" : saveName + ".log";
            FileOutputStream file = new FileOutputStream(new File(location, saveName));
            BufferedOutputStream out = new BufferedOutputStream(file);
            while ((i = in.read()) != -1) {
                out.write(i);
            }
            out.flush();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error downloading Sauce Results");
        }
    }

    protected void addAuthenticationProperty(HttpURLConnection connection) {
        if (this.username != null && this.accessKey != null) {
            String auth = this.encodeAuthentication();
            connection.setRequestProperty("Authorization", auth);
        }
    }

    public void updateJobInfo(String jobId, Map<String, Object> updates) {
        URLConnection postBack = null;
        try {
            URL restEndpoint = new URL(String.format(JOB_RESULT_FORMAT, this.username, jobId));
            postBack = this.openConnection(restEndpoint);
            postBack.setDoOutput(true);
            ((HttpURLConnection)postBack).setRequestMethod("PUT");
            this.addAuthenticationProperty((HttpURLConnection)postBack);
            String jsonText = JSONValue.toJSONString(updates);
            postBack.getOutputStream().write(jsonText.getBytes());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error updating Sauce Results", e);
        }
        try {
            if (postBack != null) {
                postBack.getInputStream().close();
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error closing result stream", e);
        }
    }

    public void stopJob(String jobId) {
        URLConnection postBack = null;
        try {
            URL restEndpoint = new URL(String.format(STOP_JOB_FORMAT, this.username, jobId));
            postBack = this.openConnection(restEndpoint);
            postBack.setDoOutput(true);
            ((HttpURLConnection)postBack).setRequestMethod("PUT");
            this.addAuthenticationProperty((HttpURLConnection)postBack);
            postBack.getOutputStream().write("".getBytes());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error stopping Sauce Job", e);
        }
        try {
            if (postBack != null) {
                postBack.getInputStream().close();
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error closing result stream", e);
        }
    }

    public HttpURLConnection openConnection(URL url) throws IOException {
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setReadTimeout((int)HTTP_READ_TIMEOUT_SECONDS);
        con.setConnectTimeout((int)HTTP_CONNECT_TIMEOUT_SECONDS);
        return con;
    }

    public String uploadFile(File file) throws IOException {
        return this.uploadFile(file, file.getName());
    }

    public String uploadFile(File file, String fileName) throws IOException {
        return this.uploadFile(file, fileName, true);
    }

    public String uploadFile(File file, String fileName, Boolean overwrite) throws IOException {
        String line;
        CookieSpecProvider customSpecProvider = new CookieSpecProvider(){

            public CookieSpec create(HttpContext context) {
                return new BrowserCompatSpec(new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy", "\"EEE, dd-MMM-yyyy HH:mm:ss z\""});
            }
        };
        Registry r = RegistryBuilder.create().register("best-match", (Object)new BestMatchSpecFactory()).register("custom", (Object)customSpecProvider).build();
        RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("custom").build();
        CloseableHttpClient client = HttpClients.custom().setDefaultCookieSpecRegistry((Lookup)r).setDefaultRequestConfig(requestConfig).build();
        HttpClientContext context = HttpClientContext.create();
        context.setCookieSpecRegistry((Lookup)r);
        HttpPost post = new HttpPost("http://saucelabs.com/rest/v1/storage/" + this.username + "/" + fileName + "?overwrite=" + overwrite.toString());
        FileEntity entity = new FileEntity(file);
        entity.setContentType((Header)new BasicHeader("Content-Type", "application/octet-stream"));
        post.setEntity((HttpEntity)entity);
        post.setHeader("Content-Type", "application/octet-stream");
        post.setHeader("Authorization", this.encodeAuthentication());
        CloseableHttpResponse response = client.execute((HttpUriRequest)post, (HttpContext)context);
        BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        StringBuilder builder = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            builder.append(line);
        }
        try {
            JSONObject sauceUploadResponse = new JSONObject(builder.toString());
            if (sauceUploadResponse.has("error")) {
                throw new UnexpectedException("Failed to upload to sauce-storage: " + sauceUploadResponse.getString("error"));
            }
            return sauceUploadResponse.getString("md5");
        }
        catch (JSONException j) {
            throw new UnexpectedException("Failed to parse json response.", (Exception)((Object)j));
        }
    }

    public String getPublicJobLink(String jobId) {
        try {
            String key = this.username + ":" + this.accessKey;
            String auth_token = SecurityUtils.hmacEncode("HmacMD5", jobId, key);
            String link = "https://saucelabs.com/jobs/" + jobId + "?auth=" + auth_token;
            return link;
        }
        catch (IllegalArgumentException ex) {
            System.err.println("Unable to create an authenticated public link to job:");
            System.err.println(ex);
            return "";
        }
    }

    protected String encodeAuthentication() {
        String auth = this.username + ":" + this.accessKey;
        BASE64Encoder encoder = new BASE64Encoder(){

            protected int bytesPerLine() {
                return 9999;
            }
        };
        auth = "Basic " + new String(encoder.encode(auth.getBytes()));
        return auth;
    }

    public void deleteTunnel(String tunnelId) {
        URLConnection postBack = null;
        try {
            URL restEndpoint = new URL(String.format(DELETE_TUNNEL_FORMAT, this.username, tunnelId));
            postBack = this.openConnection(restEndpoint);
            postBack.setDoOutput(true);
            ((HttpURLConnection)postBack).setRequestMethod("DELETE");
            this.addAuthenticationProperty((HttpURLConnection)postBack);
            postBack.getOutputStream().write("".getBytes());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error stopping Sauce Job", e);
        }
        try {
            if (postBack != null) {
                postBack.getInputStream().close();
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error closing result stream", e);
        }
    }

    public String getTunnels() {
        URL restEndpoint = null;
        try {
            restEndpoint = new URL(String.format(GET_TUNNEL_FORMAT, this.username));
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "Error constructing Sauce URL", e);
        }
        return this.retrieveResults(restEndpoint);
    }
}

