/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SecurityUtils {
    public static String hmacEncode(String algorithm, String input, String privateKey) throws IllegalArgumentException {
        try {
            byte[] keyBytes = privateKey.getBytes();
            SecretKeySpec key = new SecretKeySpec(keyBytes, 0, keyBytes.length, algorithm);
            Mac mac = Mac.getInstance(algorithm);
            mac.init(key);
            return SecurityUtils.byteArrayToHex(mac.doFinal(input.getBytes()));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalArgumentException("Unknown algorithm: " + algorithm);
        }
        catch (InvalidKeyException ex) {
            throw new IllegalArgumentException("Illegal key: " + privateKey);
        }
    }

    protected static String byteArrayToHex(byte[] bytes) {
        String hexDigitChars = "0123456789abcdef";
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        for (int cx = 0; cx < bytes.length; ++cx) {
            int hn = (bytes[cx] & 0xFF) / 16;
            int ln = bytes[cx] & 0xF;
            buf.append(hexDigitChars.charAt(hn));
            buf.append(hexDigitChars.charAt(ln));
        }
        return buf.toString();
    }
}

