/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest;

import com.saucelabs.saucerest.MappedParameterContext;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Optional;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.engine.execution.BeforeEachMethodAdapter;
import org.junit.jupiter.engine.extension.ExtensionRegistry;

public class AfterBeforeParameterResolver
implements BeforeEachMethodAdapter,
ParameterResolver {
    private ParameterResolver parameterisedTestParameterResolver = null;

    public void invokeBeforeEachMethod(ExtensionContext context, ExtensionRegistry registry) {
        Optional<ParameterResolver> resolverOptional = registry.getExtensions(ParameterResolver.class).stream().filter(parameterResolver -> parameterResolver.getClass().getName().contains("ParameterizedTestParameterResolver")).findFirst();
        if (!resolverOptional.isPresent()) {
            throw new IllegalStateException("ParameterizedTestParameterResolver missed in the registry. Probably it's not a Parameterized Test");
        }
        this.parameterisedTestParameterResolver = resolverOptional.get();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (this.isExecutedOnAfterOrBeforeMethod(parameterContext)) {
            MappedParameterContext pContext = this.getMappedContext(parameterContext, extensionContext);
            return this.parameterisedTestParameterResolver.supportsParameter((ParameterContext)pContext, extensionContext);
        }
        return false;
    }

    private MappedParameterContext getMappedContext(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return new MappedParameterContext(parameterContext.getIndex(), extensionContext.getRequiredTestMethod().getParameters()[parameterContext.getIndex()], Optional.of(parameterContext.getTarget()));
    }

    private boolean isExecutedOnAfterOrBeforeMethod(ParameterContext parameterContext) {
        return Arrays.stream(parameterContext.getDeclaringExecutable().getDeclaredAnnotations()).anyMatch(this::isAfterEachOrBeforeEachAnnotation);
    }

    private boolean isAfterEachOrBeforeEachAnnotation(Annotation annotation) {
        return annotation.annotationType() == BeforeEach.class || annotation.annotationType() == AfterEach.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.parameterisedTestParameterResolver.resolveParameter((ParameterContext)this.getMappedContext(parameterContext, extensionContext), extensionContext);
    }
}

