/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SauceShareableLink {
    public static String getJobAuthDigest(String username, String accessKey, String sauceJobId) throws NoSuchAlgorithmException, InvalidKeyException {
        String key = String.format("%s:%s", username, accessKey);
        SecretKeySpec sks = new SecretKeySpec(key.getBytes(StandardCharsets.US_ASCII), "HmacMD5");
        Mac mac = Mac.getInstance("HmacMD5");
        mac.init(sks);
        byte[] result = mac.doFinal(sauceJobId.getBytes(StandardCharsets.US_ASCII));
        StringBuilder hash = new StringBuilder();
        for (byte b : result) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hash.append('0');
            }
            hash.append(hex);
        }
        return hash.toString();
    }

    public static String getShareableLink(String username, String accessKey, String sauceJobId, String server) throws NoSuchAlgorithmException, InvalidKeyException {
        String digest = SauceShareableLink.getJobAuthDigest(username, accessKey, sauceJobId);
        return String.format("%s%s/%s?auth=%s", server, "tests", sauceJobId, digest);
    }
}

