/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest.api;

import com.saucelabs.saucerest.BuildUtils;
import com.saucelabs.saucerest.DataCenter;
import com.saucelabs.saucerest.api.ResponseHandler;
import com.saucelabs.saucerest.model.AbstractModel;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSource;
import org.json.JSONObject;

public abstract class AbstractEndpoint
extends AbstractModel {
    private static final Logger logger = Logger.getLogger(AbstractEndpoint.class.getName());
    protected final String userAgent = "SauceREST/" + BuildUtils.getCurrentVersion();
    protected final String baseURL;
    protected final String username;
    protected final String accessKey;
    protected final String credentials;

    public AbstractEndpoint(DataCenter dataCenter) {
        this.username = System.getenv("SAUCE_USERNAME");
        this.accessKey = System.getenv("SAUCE_ACCESS_KEY");
        this.credentials = this.username == null || this.accessKey == null ? null : Credentials.basic((String)this.username, (String)this.accessKey);
        this.baseURL = dataCenter.apiServer;
    }

    public AbstractEndpoint(String apiServer) {
        this.username = System.getenv("SAUCE_USERNAME");
        this.accessKey = System.getenv("SAUCE_ACCESS_KEY");
        this.credentials = this.username == null || this.accessKey == null ? null : Credentials.basic((String)this.username, (String)this.accessKey);
        this.baseURL = apiServer;
    }

    public AbstractEndpoint(String username, String accessKey, DataCenter dataCenter) {
        this.username = username;
        this.accessKey = accessKey;
        this.credentials = username == null || accessKey == null ? null : Credentials.basic((String)username, (String)accessKey);
        this.baseURL = dataCenter.apiServer;
    }

    public AbstractEndpoint(String username, String accessKey, String apiServer) {
        this.username = username;
        this.accessKey = accessKey;
        this.credentials = username == null || accessKey == null ? null : Credentials.basic((String)username, (String)accessKey);
        this.baseURL = apiServer;
    }

    protected String getBaseEndpoint() {
        return this.baseURL;
    }

    public String getResponseObject(String url) throws IOException {
        Response response = this.getResponse(url);
        return response.body().string();
    }

    public String getResponseObject(String url, Map<String, Object> params) throws IOException {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
        for (Map.Entry<String, Object> param : params.entrySet()) {
            if (param.getValue().getClass() == String[].class) {
                for (String element : (String[])param.getValue()) {
                    urlBuilder.addQueryParameter(param.getKey(), element);
                }
                continue;
            }
            urlBuilder.addQueryParameter(param.getKey(), param.getValue().toString());
        }
        Request.Builder chain = new Request.Builder();
        if (this.credentials != null) {
            chain = chain.header("Authorization", this.credentials);
        }
        Request request = chain.header("User-Agent", this.userAgent).url(urlBuilder.build().toString()).build();
        try (Response response = this.makeRequest(request);){
            String string = response.body().string();
            return string;
        }
    }

    public BufferedSource getStream(String url) throws IOException {
        Response response = this.getResponse(url);
        return response.body().source();
    }

    public String postResponse(String url, Map<String, Object> payload) throws IOException {
        return this.postResponse(url, payload, MediaType.parse((String)"application/json"));
    }

    public String postResponse(String url, Map<String, Object> payload, MediaType mediaType) throws IOException {
        String json = new JSONObject(payload).toString();
        Request.Builder chain = new Request.Builder();
        if (this.credentials != null) {
            chain = chain.header("Authorization", this.credentials);
        }
        Request request = chain.header("User-Agent", this.userAgent).url(url).post(RequestBody.create((String)json, (MediaType)mediaType)).build();
        try (Response response = this.makeRequest(request);){
            String string = response.body().string();
            return string;
        }
    }

    public String postResponse(String url) throws IOException {
        Request.Builder chain = new Request.Builder();
        if (this.credentials != null) {
            chain = chain.header("Authorization", this.credentials);
        }
        Request request = chain.header("User-Agent", this.userAgent).url(url).post(RequestBody.create((String)"", (MediaType)MediaType.parse((String)"application/json"))).build();
        try (Response response = this.makeRequest(request);){
            String string = response.body().string();
            return string;
        }
    }

    public String putResponse(String url, Map<String, Object> payload) throws IOException {
        String json = new JSONObject(payload).toString();
        Request.Builder chain = new Request.Builder();
        if (this.credentials != null) {
            chain = chain.header("Authorization", this.credentials);
        }
        Request request = chain.url(url).put(RequestBody.create((String)json, (MediaType)MediaType.parse((String)"application/json"))).build();
        try (Response response = this.makeRequest(request);){
            String string = response.body().string();
            return string;
        }
    }

    public String putResponse(String url, String payload) throws IOException {
        String json = new JSONObject(payload).toString();
        Request.Builder chain = new Request.Builder();
        if (this.credentials != null) {
            chain = chain.header("Authorization", this.credentials);
        }
        Request request = chain.url(url).put(RequestBody.create((String)json, (MediaType)MediaType.parse((String)"application/json"))).build();
        try (Response response = this.makeRequest(request);){
            String string = response.body().string();
            return string;
        }
    }

    public String patchResponse(String url, Map<String, Object> payload) throws IOException {
        String json = new JSONObject(payload).toString();
        Request.Builder chain = new Request.Builder();
        if (this.credentials != null) {
            chain = chain.header("Authorization", this.credentials);
        }
        Request request = chain.url(url).patch(RequestBody.create((String)json, (MediaType)MediaType.parse((String)"application/json"))).build();
        try (Response response = this.makeRequest(request);){
            String string = response.body().string();
            return string;
        }
    }

    public String patchResponse(String url, String payload) throws IOException {
        String json = new JSONObject(payload).toString();
        Request.Builder chain = new Request.Builder();
        if (this.credentials != null) {
            chain = chain.header("Authorization", this.credentials);
        }
        Request request = chain.url(url).patch(RequestBody.create((String)json, (MediaType)MediaType.parse((String)"application/json"))).build();
        try (Response response = this.makeRequest(request);){
            String string = response.body().string();
            return string;
        }
    }

    public String deleteResponse(String url) throws IOException {
        Request.Builder chain = new Request.Builder();
        if (this.credentials != null) {
            chain = chain.header("Authorization", this.credentials);
        }
        Request request = chain.url(url).delete().build();
        try (Response response = this.makeRequest(request);){
            String string = response.body().string();
            return string;
        }
    }

    private Response getResponse(String url) throws IOException {
        Request.Builder chain = new Request.Builder();
        if (this.credentials != null) {
            chain = chain.header("Authorization", this.credentials);
        }
        Request request = chain.url(url).build();
        return this.makeRequest(request);
    }

    protected Response makeRequest(Request request) throws IOException {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(300L, TimeUnit.SECONDS);
        builder.readTimeout(300L, TimeUnit.SECONDS);
        builder.writeTimeout(300L, TimeUnit.SECONDS);
        OkHttpClient client = builder.build();
        Response response = client.newCall(request).execute();
        Integer responseCode = response.code();
        Integer responseCodeLength = String.valueOf(responseCode).length();
        if (responseCodeLength == 3 && (responseCode == 429 || String.valueOf(responseCode).startsWith("5"))) {
            Response finalResponse = response;
            response = (Response)Failsafe.with((Policy)((RetryPolicy)new RetryPolicy().handle(RuntimeException.class)).withBackoff(30L, 500L, ChronoUnit.MILLIS).withMaxRetries(2).onRetry(e -> logger.log(Level.WARNING, () -> "Retrying because of " + finalResponse.code())), (Policy[])new RetryPolicy[0]).get(() -> client.newCall(request).execute());
        }
        if (!response.isSuccessful()) {
            ResponseHandler.responseHandler(this, response);
        }
        return response;
    }

    protected <T> T getResponseClass(String jsonResponse, Class<T> clazz) throws IOException {
        Moshi moshi = new Moshi.Builder().build();
        JsonAdapter jsonAdapter = moshi.adapter(clazz).failOnUnknown();
        return (T)jsonAdapter.fromJson(jsonResponse);
    }

    protected <T> List<T> getResponseListClass(String jsonResponse, Class<T> clazz) throws IOException {
        Moshi moshi = new Moshi.Builder().build();
        ParameterizedType listPlatform = Types.newParameterizedType(List.class, (Type[])new Type[]{clazz});
        JsonAdapter adapter = moshi.adapter((Type)listPlatform);
        return (List)adapter.fromJson(jsonResponse);
    }
}

