/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest.api;

import com.google.common.collect.ImmutableMap;
import com.saucelabs.saucerest.DataCenter;
import com.saucelabs.saucerest.api.AbstractEndpoint;
import com.saucelabs.saucerest.model.accounts.CreateTeam;
import com.saucelabs.saucerest.model.accounts.LookupTeams;
import com.saucelabs.saucerest.model.accounts.LookupUsers;
import com.saucelabs.saucerest.model.accounts.LookupUsersParameter;
import com.saucelabs.saucerest.model.accounts.Organizations;
import com.saucelabs.saucerest.model.accounts.ResetAccessKeyForTeam;
import com.saucelabs.saucerest.model.accounts.Settings;
import com.saucelabs.saucerest.model.accounts.Team;
import com.saucelabs.saucerest.model.accounts.TeamMembers;
import com.saucelabs.saucerest.model.accounts.UpdateTeam;
import com.saucelabs.saucerest.model.accounts.User;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class Accounts
extends AbstractEndpoint {
    public Accounts(DataCenter dataCenter) {
        super(dataCenter);
    }

    public Accounts(String apiServer) {
        super(apiServer);
    }

    public Accounts(String username, String accessKey, DataCenter dataCenter) {
        super(username, accessKey, dataCenter);
    }

    public Accounts(String username, String accessKey, String apiServer) {
        super(username, accessKey, apiServer);
    }

    @Override
    protected String getBaseEndpoint() {
        return super.getBaseEndpoint() + "team-management/v1/";
    }

    public LookupTeams lookupTeams() throws IOException {
        String url = this.getBaseEndpoint() + "teams/";
        return this.getResponseClass(this.getResponseObject(url), LookupTeams.class);
    }

    public LookupTeams lookupTeams(String name) throws IOException {
        String url = this.getBaseEndpoint() + "teams?name=" + name;
        return this.getResponseClass(this.getResponseObject(url), LookupTeams.class);
    }

    public Team getSpecificTeam(String teamID) throws IOException {
        String url = this.getBaseEndpoint() + "teams/" + teamID;
        return this.getResponseClass(this.getResponseObject(url), Team.class);
    }

    public CreateTeam createTeam(String name, Settings settings, String description) throws IOException {
        String url = this.getBaseEndpoint() + "teams/";
        ImmutableMap map = ImmutableMap.of((Object)"name", (Object)name, (Object)"settings", (Object)settings, (Object)"description", (Object)description);
        return this.getResponseClass(this.postResponse(url, (Map<String, Object>)map), CreateTeam.class);
    }

    public Organizations getOrganization() throws IOException {
        String url = this.getBaseEndpoint() + "organizations";
        return this.getResponseClass(this.getResponseObject(url), Organizations.class);
    }

    public void deleteTeam(String teamID) throws IOException {
        String url = this.getBaseEndpoint() + "teams/" + teamID;
        this.deleteResponse(url);
    }

    public UpdateTeam updateTeam(String teamID, String name, Settings settings, String description) throws IOException {
        String url = this.getBaseEndpoint() + "teams/" + teamID;
        ImmutableMap map = ImmutableMap.of((Object)"name", (Object)name, (Object)"settings", (Object)settings, (Object)"description", (Object)description);
        return this.getResponseClass(this.putResponse(url, (Map<String, Object>)map), UpdateTeam.class);
    }

    public UpdateTeam partiallyUpdateTeam(String teamID, UpdateTeam updateTeam) throws IOException {
        String url = this.getBaseEndpoint() + "teams/" + teamID;
        return this.getResponseClass(this.patchResponse(url, updateTeam.toJson()), UpdateTeam.class);
    }

    public TeamMembers getTeamMembers(String teamID) throws IOException {
        String url = this.getBaseEndpoint() + "teams/" + teamID + "/members";
        return this.getResponseClass(this.getResponseObject(url), TeamMembers.class);
    }

    public List<ResetAccessKeyForTeam> resetAccessKeyForTeam(String teamID) throws IOException {
        String url = this.getBaseEndpoint() + "teams/" + teamID + "/reset-access-key";
        return this.getResponseListClass(this.postResponse(url), ResetAccessKeyForTeam.class);
    }

    public LookupUsers lookupUsers() throws IOException {
        String url = this.getBaseEndpoint() + "users/";
        return this.getResponseClass(this.getResponseObject(url), LookupUsers.class);
    }

    public LookupUsers lookupUsers(LookupUsersParameter lookupUsersParameter) throws IOException {
        String url = this.getBaseEndpoint() + "users/";
        return this.getResponseClass(this.getResponseObject(url, lookupUsersParameter.toMap()), LookupUsers.class);
    }

    public User getUser(String userID) throws IOException {
        String url = this.getBaseEndpoint() + "users/" + userID;
        return this.getResponseClass(this.getResponseObject(url), User.class);
    }
}

