/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest.api;

import com.google.common.collect.ImmutableMap;
import com.saucelabs.saucerest.DataCenter;
import com.saucelabs.saucerest.api.AbstractEndpoint;
import com.saucelabs.saucerest.model.realdevices.AvailableDevices;
import com.saucelabs.saucerest.model.realdevices.Device;
import com.saucelabs.saucerest.model.realdevices.DeviceJob;
import com.saucelabs.saucerest.model.realdevices.DeviceJobs;
import com.saucelabs.saucerest.model.realdevices.Devices;
import java.io.IOException;
import java.util.Map;

public class RealDevices
extends AbstractEndpoint {
    public RealDevices(DataCenter dataCenter) {
        super(dataCenter);
    }

    public RealDevices(String apiServer) {
        super(apiServer);
    }

    public RealDevices(String username, String accessKey, DataCenter dataCenter) {
        super(username, accessKey, dataCenter);
    }

    public RealDevices(String username, String accessKey, String apiServer) {
        super(username, accessKey, apiServer);
    }

    public Devices getDevices() throws IOException {
        String url = this.getBaseEndpoint() + "/devices";
        return new Devices(this.getResponseListClass(this.getResponseObject(url), Device.class));
    }

    public Device getSpecificDevice(String deviceID) throws IOException {
        String url = this.getBaseEndpoint() + "/devices/" + deviceID;
        return this.getResponseClass(this.getResponseObject(url), Device.class);
    }

    public AvailableDevices getAvailableDevices() throws IOException {
        String url = this.getBaseEndpoint() + "/devices/available";
        return new AvailableDevices(this.getResponseListClass(this.getResponseObject(url), String.class));
    }

    public DeviceJobs getDeviceJobs() throws IOException {
        String url = this.getBaseEndpoint() + "/jobs";
        return this.getResponseClass(this.getResponseObject(url), DeviceJobs.class);
    }

    public DeviceJobs getDeviceJobs(ImmutableMap<String, Object> params) throws IOException {
        String url = this.getBaseEndpoint() + "/jobs";
        return this.getResponseClass(this.getResponseObject(url, (Map<String, Object>)params), DeviceJobs.class);
    }

    public DeviceJob getSpecificDeviceJob(String jobID) throws IOException {
        String url = this.getBaseEndpoint() + "/jobs/" + jobID;
        return this.getResponseClass(this.getResponseObject(url), DeviceJob.class);
    }

    public void deleteSpecificRealDeviceJob(String jobID) {
        String url = this.getBaseEndpoint() + "/jobs/" + jobID;
        try {
            this.deleteResponse(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected String getBaseEndpoint() {
        return super.getBaseEndpoint() + "v1/rdc";
    }
}

