/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest.api;

import com.saucelabs.saucerest.ErrorExplainers;
import com.saucelabs.saucerest.HttpMethod;
import com.saucelabs.saucerest.SauceException;
import com.saucelabs.saucerest.api.AbstractEndpoint;
import com.saucelabs.saucerest.api.Job;
import com.saucelabs.saucerest.api.SauceConnect;
import okhttp3.Response;

public class ResponseHandler {
    public static void responseHandler(AbstractEndpoint endpoint, Response response) {
        switch (response.code()) {
            case 404: {
                if (endpoint instanceof SauceConnect) {
                    if (response.request().method().equals(HttpMethod.DELETE.label)) {
                        String tunnelID = (String)response.request().url().pathSegments().get(response.request().url().pathSegments().size() - 1);
                        throw new SauceException.NotFound(String.join((CharSequence)System.lineSeparator(), ErrorExplainers.TunnelNotFound(tunnelID)));
                    }
                } else {
                    throw new SauceException.NotFound();
                }
            }
            case 401: {
                throw new SauceException.NotAuthorized(ResponseHandler.checkCredentials(endpoint));
            }
            case 400: {
                if (!(endpoint instanceof Job)) break;
                if (response.message().equalsIgnoreCase("Job hasn't finished running")) {
                    throw new SauceException.NotYetDone(ErrorExplainers.JobNotYetDone());
                }
                throw new RuntimeException("Unexpected code " + response);
            }
        }
        throw new RuntimeException("Unexpected code " + response);
    }

    private static String checkCredentials(AbstractEndpoint endpoint) {
        String username = endpoint.username;
        String accessKey = endpoint.accessKey;
        if ((username == null || username.isEmpty()) && (accessKey == null || accessKey.isEmpty())) {
            return String.join((CharSequence)System.lineSeparator(), "Your username and access key are empty or blank.", ErrorExplainers.missingCreds());
        }
        if (username == null || username.isEmpty()) {
            return String.join((CharSequence)System.lineSeparator(), "Your username is empty or blank.", ErrorExplainers.missingCreds());
        }
        if (accessKey == null || accessKey.isEmpty()) {
            return String.join((CharSequence)System.lineSeparator(), "Your access key is empty or blank.", ErrorExplainers.missingCreds());
        }
        return ErrorExplainers.incorrectCreds(username, accessKey);
    }
}

