/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest.api;

import com.google.common.collect.ImmutableMap;
import com.saucelabs.saucerest.DataCenter;
import com.saucelabs.saucerest.api.AbstractEndpoint;
import com.saucelabs.saucerest.model.storage.DeleteAppFile;
import com.saucelabs.saucerest.model.storage.DeleteAppGroupFiles;
import com.saucelabs.saucerest.model.storage.EditAppGroupSettings;
import com.saucelabs.saucerest.model.storage.EditFileDescription;
import com.saucelabs.saucerest.model.storage.GetAppFiles;
import com.saucelabs.saucerest.model.storage.GetAppStorageGroupSettings;
import com.saucelabs.saucerest.model.storage.GetAppStorageGroups;
import com.saucelabs.saucerest.model.storage.UploadFileApp;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;

public class Storage
extends AbstractEndpoint {
    public Storage(DataCenter dataCenter) {
        super(dataCenter);
    }

    public Storage(String apiServer) {
        super(apiServer);
    }

    public Storage(String username, String accessKey, DataCenter dataCenter) {
        super(username, accessKey, dataCenter);
    }

    public Storage(String username, String accessKey, String apiServer) {
        super(username, accessKey, apiServer);
    }

    public GetAppFiles getFiles() throws IOException {
        String url = this.getBaseEndpoint() + "/files";
        return this.getResponseClass(this.getResponseObject(url), GetAppFiles.class);
    }

    public GetAppFiles getFiles(Map<String, Object> params) throws IOException {
        String url = this.getBaseEndpoint() + "/files";
        return this.getResponseClass(this.getResponseObject(url, params), GetAppFiles.class);
    }

    public GetAppStorageGroups getGroups() throws IOException {
        String url = this.getBaseEndpoint() + "/groups";
        return this.getResponseClass(this.getResponseObject(url), GetAppStorageGroups.class);
    }

    public GetAppStorageGroups getGroups(Map<String, Object> params) throws IOException {
        String url = this.getBaseEndpoint() + "/groups";
        return this.getResponseClass(this.getResponseObject(url, params), GetAppStorageGroups.class);
    }

    public GetAppStorageGroupSettings getGroupSettings(int groupId) throws IOException {
        String url = this.getBaseEndpoint() + "/groups/" + groupId + "/settings";
        return this.getResponseClass(this.getResponseObject(url), GetAppStorageGroupSettings.class);
    }

    public EditAppGroupSettings updateAppStorageGroupSettings(int groupId, String jsonBody) throws IOException {
        String url = this.getBaseEndpoint() + "/groups/" + groupId + "/settings";
        return this.getResponseClass(this.putResponse(url, jsonBody), EditAppGroupSettings.class);
    }

    public EditAppGroupSettings updateAppStorageGroupSettings(int groupId, EditAppGroupSettings editAppGroupSettings) throws IOException {
        String url = this.getBaseEndpoint() + "/groups/" + groupId + "/settings";
        return this.getResponseClass(this.putResponse(url, editAppGroupSettings.toJson()), EditAppGroupSettings.class);
    }

    public UploadFileApp uploadFile(File file) throws IOException {
        return this.uploadFile(file, "", "");
    }

    public UploadFileApp uploadFile(File file, String fileName) throws IOException {
        return this.uploadFile(file, fileName, "");
    }

    public UploadFileApp uploadFile(File file, String fileName, String description) throws IOException {
        String url = this.getBaseEndpoint() + "/upload";
        return this.getResponseClass(this.postMultipartResponse(url, file, fileName, description), UploadFileApp.class);
    }

    public void downloadFile(String fileId, Path path) throws IOException {
        String url = this.getBaseEndpoint() + "/download/" + fileId;
        try (Response response = this.getResponse(url);){
            FileUtils.writeByteArrayToFile((File)new File(path.toFile().toURI()), (byte[])Objects.requireNonNull(response.body()).bytes());
        }
    }

    public EditFileDescription updateFileDescription(String fileId, String description) throws IOException {
        String url = this.getBaseEndpoint() + "/files/" + fileId;
        JSONObject json = new JSONObject((Map)ImmutableMap.of((Object)"item", (Object)ImmutableMap.of((Object)"description", (Object)description)));
        return this.getResponseClass(this.putResponse(url, json.toString()), EditFileDescription.class);
    }

    public DeleteAppFile deleteFile(String fileId) throws IOException {
        String url = this.getBaseEndpoint() + "/files/" + fileId;
        return this.getResponseClass(this.deleteResponse(url), DeleteAppFile.class);
    }

    public DeleteAppGroupFiles deleteFileGroup(int groupId) throws IOException {
        String url = this.getBaseEndpoint() + "/groups/" + groupId;
        return this.getResponseClass(this.deleteResponse(url), DeleteAppGroupFiles.class);
    }

    @Override
    protected String getBaseEndpoint() {
        return super.getBaseEndpoint() + "v1/storage";
    }

    private String postMultipartResponse(String url, File file, String fileName, String description) throws IOException {
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("name", fileName).addFormDataPart("description", description).addFormDataPart("payload", file.getName(), RequestBody.create((File)file, (MediaType)MediaType.parse((String)"application/octet-stream"))).build();
        Request request = new Request.Builder().header("Authorization", this.credentials).url(url).post((RequestBody)requestBody).build();
        try (Response response = this.makeRequest(request);){
            if (!response.isSuccessful()) {
                System.out.println(response.body().toString());
                throw new IOException("Unexpected code" + response);
            }
            String string = response.body().string();
            return string;
        }
    }

    private Response getResponse(String url) throws IOException {
        Request request = new Request.Builder().header("Authorization", this.credentials).url(url).build();
        return this.makeRequest(request);
    }
}

