/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest.model.accounts;

import java.util.HashMap;
import java.util.Map;

public class LookupUsersParameter {
    private final String username;
    private final String teams;
    private final String teamName;
    private final Integer roles;
    private final String phrase;
    private final String status;
    private final Integer limit;
    private final Integer offset;

    public LookupUsersParameter(String username, String teams, String teamName, Integer roles, String phrase, String status, Integer limit, Integer offset) {
        this.username = username;
        this.teams = teams;
        this.teamName = teamName;
        this.roles = roles;
        this.phrase = phrase;
        this.status = status;
        this.limit = limit;
        this.offset = offset;
    }

    private LookupUsersParameter(Builder builder) {
        this.username = builder.username;
        this.teams = builder.teams;
        this.teamName = builder.teamName;
        this.roles = builder.roles;
        this.phrase = builder.phrase;
        this.status = builder.status;
        this.limit = builder.limit;
        this.offset = builder.offset;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.username != null) {
            parameters.put("username", this.username);
        }
        if (this.teams != null) {
            parameters.put("teams", this.teams);
        }
        if (this.teamName != null) {
            parameters.put("team_name", this.teamName);
        }
        if (this.roles != null) {
            parameters.put("roles", this.roles);
        }
        if (this.phrase != null) {
            parameters.put("phrase", this.phrase);
        }
        if (this.status != null) {
            parameters.put("status", this.status);
        }
        if (this.limit != null) {
            parameters.put("limit", this.limit);
        }
        if (this.offset != null) {
            parameters.put("offset", this.offset);
        }
        return parameters;
    }

    public static final class Builder {
        private String username;
        private String teams;
        private String teamName;
        private Integer roles;
        private String phrase;
        private String status;
        private Integer limit;
        private Integer offset;

        public Builder setUsername(String val) {
            this.username = val;
            return this;
        }

        public Builder setTeams(String val) {
            this.teams = val;
            return this;
        }

        public Builder setTeams(String ... val) {
            this.teams = String.join((CharSequence)",", val);
            return this;
        }

        public Builder setTeamName(String val) {
            this.teamName = val;
            return this;
        }

        public Builder setRoles(Roles val) {
            this.roles = val.value;
            return this;
        }

        public Builder setPhrase(String val) {
            this.phrase = val;
            return this;
        }

        public Builder setStatus(Status val) {
            this.status = val.value;
            return this;
        }

        public Builder setLimit(Integer val) {
            this.limit = val;
            return this;
        }

        public Builder setOffset(Integer val) {
            this.offset = val;
            return this;
        }

        public LookupUsersParameter build() {
            if (this.limit == null) {
                this.limit = 20;
            }
            if (this.limit > 100) {
                throw new IllegalArgumentException("Limit cannot be greater than 100");
            }
            return new LookupUsersParameter(this);
        }
    }

    public static enum Status {
        ACTIVE("active"),
        PENDING("pending"),
        INACTIVE("inactive");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Roles {
        ORGADMIN(1),
        TEAMADMIN(4),
        MEMBER(3);

        private final int value;

        private Roles(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

