/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest.model.storage;

import com.saucelabs.saucerest.ErrorExplainers;
import com.saucelabs.saucerest.SauceException;
import com.saucelabs.saucerest.model.AbstractModel;
import com.saucelabs.saucerest.model.storage.Settings;
import com.squareup.moshi.Json;
import java.util.stream.Stream;

public class EditAppGroupSettings
extends AbstractModel {
    @Json(name="settings")
    public Settings settings;
    @Json(name="kind")
    public String kind;
    @Json(name="identifier")
    public String identifier;

    private EditAppGroupSettings(Builder builder) {
        this.settings = builder.settings;
    }

    public static final class Builder {
        private Settings settings;
        private final Platform platform;

        public Builder(Platform platform) {
            this.platform = platform;
        }

        public Builder setSettings(Settings val) {
            this.settings = val;
            return this;
        }

        public EditAppGroupSettings build() {
            if (this.platform.equals((Object)Platform.IOS)) {
                if (this.settings.instrumentationEnabled != null || this.settings.instrumentation != null) {
                    throw new SauceException.InstrumentationNotAllowed(ErrorExplainers.InstrumentationNotAllowed());
                }
                if (this.settings.setupDeviceLock != null) {
                    throw new SauceException.DeviceLockOnlyOnAndroid(ErrorExplainers.DeviceLockOnlyOnAndroid());
                }
            }
            if (this.platform.equals((Object)Platform.ANDROID) && (this.settings.resigningEnabled != null || this.settings.resigning != null)) {
                throw new SauceException.ResigningNotAllowed(ErrorExplainers.ResigningNotAllowed());
            }
            return new EditAppGroupSettings(this);
        }

        public static enum Platform {
            IOS,
            ANDROID;


            public static Platform fromString(String platform) {
                return Stream.of(Platform.values()).filter(p -> p.name().equalsIgnoreCase(platform)).findFirst().orElse(null);
            }
        }
    }
}

