/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest.api;

import com.saucelabs.saucerest.ErrorExplainers;
import com.saucelabs.saucerest.HttpMethod;
import com.saucelabs.saucerest.SauceException;
import com.saucelabs.saucerest.api.AbstractEndpoint;
import com.saucelabs.saucerest.api.AccountsEndpoint;
import com.saucelabs.saucerest.api.JobsEndpoint;
import com.saucelabs.saucerest.api.SauceConnectEndpoint;
import com.saucelabs.saucerest.api.StorageEndpoint;
import okhttp3.Response;

public class ResponseHandler {
    private ResponseHandler() {
        throw new IllegalStateException("Utility class");
    }

    public static void responseHandler(AbstractEndpoint endpoint, Response response) {
        switch (response.code()) {
            case 404: {
                if (endpoint instanceof SauceConnectEndpoint) {
                    if (response.request().method().equals(HttpMethod.DELETE.label)) {
                        String tunnelID = ResponseHandler.getID(response);
                        throw new SauceException.NotFound(String.join((CharSequence)System.lineSeparator(), ErrorExplainers.TunnelNotFound(tunnelID)));
                    }
                } else {
                    if (endpoint instanceof StorageEndpoint) {
                        String appFileID = ResponseHandler.getID(response);
                        throw new SauceException.NotFound(String.join((CharSequence)System.lineSeparator(), ErrorExplainers.AppNotFound(appFileID)));
                    }
                    if (endpoint instanceof AccountsEndpoint) {
                        String accountID = ResponseHandler.getID(response);
                        throw new SauceException.NotFound(String.join((CharSequence)System.lineSeparator(), ErrorExplainers.AccountNotFound(accountID)));
                    }
                }
                throw new SauceException.NotFound();
            }
            case 401: {
                throw new SauceException.NotAuthorized(ResponseHandler.checkCredentials(endpoint));
            }
            case 400: {
                if (endpoint instanceof JobsEndpoint && response.message().equalsIgnoreCase("Job hasn't finished running")) {
                    throw new SauceException.NotYetDone(ErrorExplainers.JobNotYetDone());
                }
                throw new RuntimeException("Unexpected code " + String.valueOf(response));
            }
        }
        throw new RuntimeException("Unexpected code " + String.valueOf(response));
    }

    private static String getID(Response response) {
        String ID = ResponseHandler.getLastPathSegment(response, 1);
        if (!ID.matches("[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}") || !ID.matches("\\d+")) {
            return ResponseHandler.getLastPathSegment(response, 2);
        }
        return ID;
    }

    private static String getLastPathSegment(Response response, int offset) {
        if (offset == 0) {
            offset = 1;
        }
        return (String)response.request().url().pathSegments().get(response.request().url().pathSegments().size() - offset);
    }

    private static String checkCredentials(AbstractEndpoint endpoint) {
        String username = endpoint.username;
        String accessKey = endpoint.accessKey;
        if ((username == null || username.isEmpty()) && (accessKey == null || accessKey.isEmpty())) {
            return String.join((CharSequence)System.lineSeparator(), "Your username and access key are empty or blank.", ErrorExplainers.missingCreds());
        }
        if (username == null || username.isEmpty()) {
            return String.join((CharSequence)System.lineSeparator(), "Your username is empty or blank.", ErrorExplainers.missingCreds());
        }
        if (accessKey == null || accessKey.isEmpty()) {
            return String.join((CharSequence)System.lineSeparator(), "Your access key is empty or blank.", ErrorExplainers.missingCreds());
        }
        return ErrorExplainers.incorrectCreds(username, accessKey);
    }
}

