/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest.model.jobs;

import com.saucelabs.saucerest.JobVisibility;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateJobParameter {
    private final String name;
    private final List<String> tags;
    private final JobVisibility visibility;
    private final Boolean passed;
    private final String build;
    private final Map<String, String> customData;

    public UpdateJobParameter(String name, List<String> tags, JobVisibility visibility, boolean passed, String build, Map<String, String> customData) {
        this.name = name;
        this.tags = tags;
        this.visibility = visibility;
        this.passed = passed;
        this.build = build;
        this.customData = customData;
    }

    private UpdateJobParameter(Builder builder) {
        this.name = builder.name;
        this.tags = builder.tags;
        this.visibility = builder.visibility;
        this.passed = builder.passed;
        this.build = builder.build;
        this.customData = builder.customData;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.name != null) {
            parameters.put("name", this.name);
        }
        if (this.tags != null) {
            parameters.put("tags", this.tags);
        }
        if (this.visibility != null) {
            parameters.put("public", this.visibility.value);
        }
        if (this.passed != null) {
            parameters.put("passed", this.passed);
        }
        if (this.build != null) {
            parameters.put("build", this.build);
        }
        if (this.customData != null) {
            parameters.put("custom-data", this.customData);
        }
        return parameters;
    }

    public static final class Builder {
        private String name;
        private List<String> tags;
        private JobVisibility visibility;
        private Boolean passed;
        private String build;
        private Map<String, String> customData;

        public Builder setName(String val) {
            this.name = val;
            return this;
        }

        public Builder setTags(List<String> val) {
            this.tags = val;
            return this;
        }

        public Builder setVisibility(JobVisibility val) {
            this.visibility = val;
            return this;
        }

        public Builder setPassed(boolean val) {
            this.passed = val;
            return this;
        }

        public Builder setBuild(String val) {
            this.build = val;
            return this;
        }

        public Builder setCustomData(Map<String, String> val) {
            this.customData = val;
            return this;
        }

        public UpdateJobParameter build() {
            return new UpdateJobParameter(this);
        }
    }
}

