/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest.model.jobs;

import java.util.HashMap;
import java.util.Map;

public class GetJobsParameters {
    private final String username;
    private final int limit;
    private final int skip;
    private final int from;
    private final int to;
    private final Format format;

    public GetJobsParameters(String username, int limit, int skip, int from, int to, Format format) {
        this.username = username;
        this.limit = limit;
        this.skip = skip;
        this.from = from;
        this.to = to;
        this.format = format;
    }

    private GetJobsParameters(Builder builder) {
        this.username = builder.username;
        this.limit = builder.limit;
        this.skip = builder.skip;
        this.from = builder.from;
        this.to = builder.to;
        this.format = builder.format;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.username != null) {
            parameters.put("username", this.username);
        }
        if (this.limit > 0) {
            parameters.put("limit", this.limit);
        }
        if (this.skip > 0) {
            parameters.put("skip", this.skip);
        }
        if (this.from > 0) {
            parameters.put("from", this.from);
        }
        if (this.to > 0) {
            parameters.put("to", this.to);
        }
        if (this.format != null) {
            parameters.put("format", (Object)this.format);
        }
        return parameters;
    }

    public static enum Format {
        JSON("json"),
        CSV("csv");

        private final String value;

        private Format(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static final class Builder {
        private String username;
        private int limit;
        private int skip;
        private int from;
        private int to;
        private Format format;

        public Builder setUsername(String val) {
            this.username = val;
            return this;
        }

        public Builder setLimit(int val) {
            this.limit = val;
            return this;
        }

        public Builder setSkip(int val) {
            this.skip = val;
            return this;
        }

        public Builder setFrom(int val) {
            this.from = val;
            return this;
        }

        public Builder setTo(int val) {
            this.to = val;
            return this;
        }

        public Builder setFormat(Format val) {
            this.format = val;
            return this;
        }

        public GetJobsParameters build() {
            return new GetJobsParameters(this);
        }
    }
}

