/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest.api;

import com.saucelabs.saucerest.DataCenter;
import com.saucelabs.saucerest.HttpMethod;
import com.saucelabs.saucerest.api.AbstractEndpoint;
import com.saucelabs.saucerest.model.accounts.CreateTeam;
import com.saucelabs.saucerest.model.accounts.CreateUser;
import com.saucelabs.saucerest.model.accounts.LookupTeams;
import com.saucelabs.saucerest.model.accounts.LookupUsers;
import com.saucelabs.saucerest.model.accounts.LookupUsersParameter;
import com.saucelabs.saucerest.model.accounts.Organizations;
import com.saucelabs.saucerest.model.accounts.ResetAccessKeyForTeam;
import com.saucelabs.saucerest.model.accounts.SetTeam;
import com.saucelabs.saucerest.model.accounts.Settings;
import com.saucelabs.saucerest.model.accounts.Team;
import com.saucelabs.saucerest.model.accounts.TeamMembers;
import com.saucelabs.saucerest.model.accounts.UpdateTeam;
import com.saucelabs.saucerest.model.accounts.UpdateUser;
import com.saucelabs.saucerest.model.accounts.User;
import com.saucelabs.saucerest.model.accounts.UserConcurrency;
import com.saucelabs.saucerest.model.accounts.UsersTeam;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.Response;

public class AccountsEndpoint
extends AbstractEndpoint {
    public AccountsEndpoint(DataCenter dataCenter) {
        super(dataCenter);
    }

    public AccountsEndpoint(String apiServer) {
        super(apiServer);
    }

    public AccountsEndpoint(String username, String accessKey, DataCenter dataCenter) {
        super(username, accessKey, dataCenter);
    }

    public AccountsEndpoint(String username, String accessKey, String apiServer) {
        super(username, accessKey, apiServer);
    }

    @Override
    protected String getBaseEndpoint() {
        return super.getBaseEndpoint() + "team-management/v1/";
    }

    public LookupTeams lookupTeams() throws IOException {
        String url = this.getBaseEndpoint() + "teams/";
        return this.deserializeJSONObject(this.request(url, HttpMethod.GET), LookupTeams.class);
    }

    public LookupTeams lookupTeams(String name) throws IOException {
        String url = this.getBaseEndpoint() + "teams?name=" + name;
        return this.deserializeJSONObject(this.request(url, HttpMethod.GET), LookupTeams.class);
    }

    public Team getSpecificTeam(String teamID) throws IOException {
        String url = this.getBaseEndpoint() + "teams/" + teamID;
        return this.deserializeJSONObject(this.request(url, HttpMethod.GET), Team.class);
    }

    public CreateTeam createTeam(String name, Settings settings, String description) throws IOException {
        String url = this.getBaseEndpoint() + "teams/";
        Map<String, Object> map = Map.of("name", name, "settings", settings, "description", description);
        return this.deserializeJSONObject(this.request(url, HttpMethod.POST, map), CreateTeam.class);
    }

    public CreateTeam createTeam(String name, Integer VMConcurrency, String description) throws IOException {
        return this.createTeam(name, new Settings.Builder().setVirtualMachines(VMConcurrency).build(), description);
    }

    public Organizations getOrganization() throws IOException {
        String url = this.getBaseEndpoint() + "organizations";
        return this.deserializeJSONObject(this.request(url, HttpMethod.GET), Organizations.class);
    }

    public Response deleteTeam(String teamID) throws IOException {
        String url = this.getBaseEndpoint() + "teams/" + teamID;
        return this.request(url, HttpMethod.DELETE);
    }

    public UpdateTeam updateTeam(String teamID, String name, Settings settings, String description) throws IOException {
        String url = this.getBaseEndpoint() + "teams/" + teamID;
        Map<String, Object> map = Map.of("name", name, "settings", settings, "description", description);
        return this.deserializeJSONObject(this.request(url, HttpMethod.PUT, map), UpdateTeam.class);
    }

    public UpdateTeam partiallyUpdateTeam(String teamID, UpdateTeam updateTeam) throws IOException {
        String url = this.getBaseEndpoint() + "teams/" + teamID;
        return this.deserializeJSONObject(this.request(url, HttpMethod.PATCH, updateTeam.toJson()), UpdateTeam.class);
    }

    public TeamMembers getTeamMembers(String teamID) throws IOException {
        String url = this.getBaseEndpoint() + "teams/" + teamID + "/members";
        return this.deserializeJSONObject(this.request(url, HttpMethod.GET), TeamMembers.class);
    }

    public List<ResetAccessKeyForTeam> resetAccessKeyForTeam(String teamID) throws IOException {
        String url = this.getBaseEndpoint() + "teams/" + teamID + "/reset-access-key";
        return this.deserializeJSONArray(this.request(url, HttpMethod.POST, ""), ResetAccessKeyForTeam.class);
    }

    public LookupUsers lookupUsers() throws IOException {
        String url = this.getBaseEndpoint() + "users/";
        return this.deserializeJSONObject(this.request(url, HttpMethod.GET), LookupUsers.class);
    }

    public LookupUsers lookupUsers(LookupUsersParameter lookupUsersParameter) throws IOException {
        String url = this.getBaseEndpoint() + "users/";
        return this.deserializeJSONObject(this.requestWithQueryParameters(url, HttpMethod.GET, lookupUsersParameter.toMap()), LookupUsers.class);
    }

    public User getUser(String userID) throws IOException {
        String url = this.getBaseEndpoint() + "users/" + userID;
        return this.deserializeJSONObject(this.request(url, HttpMethod.GET), User.class);
    }

    public User createUser(CreateUser createUser) throws IOException {
        String url = this.getBaseEndpoint() + "users/";
        return this.deserializeJSONObject(this.request(url, HttpMethod.POST, createUser.toMap()), User.class);
    }

    public User updateUser(UpdateUser updateUser) throws IOException {
        String url = this.getBaseEndpoint() + "users/" + updateUser.getUserID();
        return this.deserializeJSONObject(this.request(url, HttpMethod.PUT, updateUser.toMap()), User.class);
    }

    public User partiallyUpdateUser(UpdateUser updateUser) throws IOException {
        String url = this.getBaseEndpoint() + "users/" + updateUser.getUserID();
        return this.deserializeJSONObject(this.request(url, HttpMethod.PATCH, updateUser.toMap()), User.class);
    }

    public UserConcurrency getUserConcurrency(String username) throws IOException {
        String url = super.getBaseEndpoint() + "rest/v1.2/users/" + username + "/concurrency";
        return this.deserializeJSONObject(this.request(url, HttpMethod.GET), UserConcurrency.class);
    }

    public UsersTeam getUsersTeam(String userID) throws IOException {
        String url = this.getBaseEndpoint() + "users/" + userID + "/teams/";
        return this.deserializeJSONObject(this.request(url, HttpMethod.GET), UsersTeam.class);
    }

    public SetTeam setUsersTeam(String userID, String teamID) throws IOException {
        String url = this.getBaseEndpoint() + "membership";
        Map<String, Object> map = Map.of("user", userID, "team", teamID);
        return this.deserializeJSONObject(this.request(url, HttpMethod.POST, map), SetTeam.class);
    }

    public User setAdmin(String userID) throws IOException {
        String url = this.getBaseEndpoint() + "users/" + userID + "/set-admin";
        return this.deserializeJSONObject(this.request(url, HttpMethod.POST), User.class);
    }

    public User setTeamAdmin(String userID) throws IOException {
        String url = this.getBaseEndpoint() + "users/" + userID + "/set-team-admin";
        return this.deserializeJSONObject(this.request(url, HttpMethod.POST), User.class);
    }

    public User setMember(String userID) throws IOException {
        String url = this.getBaseEndpoint() + "users/" + userID + "/set-member";
        return this.deserializeJSONObject(this.request(url, HttpMethod.POST), User.class);
    }

    public User getAccessKey(String userID) throws IOException {
        String url = this.getBaseEndpoint() + "users/" + userID + "/access-key";
        return this.deserializeJSONObject(this.request(url, HttpMethod.GET), User.class);
    }

    public List<User> resetAccessKey(String userID) throws IOException {
        String url = this.getBaseEndpoint() + "users/" + userID + "/reset-access-key";
        return this.deserializeJSONArray(this.request(url, HttpMethod.POST), User.class);
    }

    public User deactivateUser(String userID) throws IOException {
        String url = this.getBaseEndpoint() + "users/" + userID + "/deactivate";
        return this.deserializeJSONObject(this.request(url, HttpMethod.POST), User.class);
    }

    public User activateUser(String userID) throws IOException {
        String url = this.getBaseEndpoint() + "users/" + userID + "/activate";
        return this.deserializeJSONObject(this.request(url, HttpMethod.POST), User.class);
    }
}

