/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest.api;

import com.saucelabs.saucerest.AutomationBackend;
import com.saucelabs.saucerest.DataCenter;
import com.saucelabs.saucerest.HttpMethod;
import com.saucelabs.saucerest.JobVisibility;
import com.saucelabs.saucerest.TestAsset;
import com.saucelabs.saucerest.api.AbstractEndpoint;
import com.saucelabs.saucerest.model.jobs.GetJobsParameters;
import com.saucelabs.saucerest.model.jobs.Job;
import com.saucelabs.saucerest.model.jobs.JobAssets;
import com.saucelabs.saucerest.model.jobs.UpdateJobParameter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okhttp3.Response;
import org.awaitility.Awaitility;
import org.json.JSONException;
import org.json.JSONObject;

public class JobsEndpoint
extends AbstractEndpoint {
    public JobsEndpoint(DataCenter dataCenter) {
        super(dataCenter);
    }

    public JobsEndpoint(String apiServer) {
        super(apiServer);
    }

    public JobsEndpoint(String username, String accessKey, DataCenter dataCenter) {
        super(username, accessKey, dataCenter);
    }

    public JobsEndpoint(String username, String accessKey, String apiServer) {
        super(username, accessKey, apiServer);
    }

    public List<Job> getJobs() throws IOException {
        String url = super.getBaseEndpoint() + "rest/v1/" + this.username + "/jobs";
        return new ArrayList<Job>(this.deserializeJSONArray(this.request(url, HttpMethod.GET), Job.class));
    }

    public ArrayList<Job> getJobs(GetJobsParameters getJobsParameters) throws IOException {
        String url = super.getBaseEndpoint() + "rest/v1/" + this.username + "/jobs";
        return new ArrayList<Job>(this.deserializeJSONArray(this.requestWithQueryParameters(url, HttpMethod.GET, getJobsParameters.toMap()), Job.class));
    }

    public Job getJobDetails(String jobID) throws IOException {
        String url = this.getBaseEndpoint() + jobID;
        return this.deserializeJSONObject(this.request(url, HttpMethod.GET), Job.class);
    }

    public List<Job> getJobDetails(List<String> jobIDs) throws IOException {
        ArrayList<Job> jobs = new ArrayList<Job>();
        for (String jobID : jobIDs) {
            String url = this.getBaseEndpoint() + jobID;
            jobs.add(this.deserializeJSONObject(this.request(url, HttpMethod.GET), Job.class));
        }
        return jobs;
    }

    public Job updateJob(String jobID, UpdateJobParameter updateJobParameter) throws IOException {
        String url = this.getBaseEndpoint() + jobID;
        return this.deserializeJSONObject(this.request(url, HttpMethod.PUT, updateJobParameter.toMap()), Job.class);
    }

    public Job stopJob(String jobID) throws IOException {
        String url = this.getBaseEndpoint() + jobID + "/stop";
        return this.deserializeJSONObject(this.request(url, HttpMethod.PUT), Job.class);
    }

    public Response deleteJob(String jobID) throws IOException {
        String url = this.getBaseEndpoint() + jobID;
        return this.request(url, HttpMethod.DELETE);
    }

    public JobAssets listJobAssets(String jobID) throws IOException {
        String url = this.getBaseEndpoint() + jobID + "/assets";
        this.waitForFinishedTest(jobID);
        this.waitForBasicTestAssets(jobID);
        return this.deserializeJSONObject(this.request(url, HttpMethod.GET), JobAssets.class);
    }

    public void downloadJobAsset(String jobID, Path path, TestAsset testAsset) throws IOException {
        String url = this.getBaseEndpoint() + jobID + "/assets/" + testAsset.label;
        try (Response response = this.request(url, HttpMethod.GET);){
            Files.write(path, Objects.requireNonNull(response.body()).bytes(), new OpenOption[0]);
        }
    }

    public void downloadAllScreenshots(String jobID, Path path) throws IOException {
        String url = this.getBaseEndpoint() + jobID + "/assets/screenshots.zip";
        try (Response response = this.request(url, HttpMethod.GET);){
            Files.write(path, Objects.requireNonNull(response.body()).bytes(), new OpenOption[0]);
        }
    }

    public void downloadAllAssets(String jobID, Path path) throws IOException {
        JobAssets jobAssets = this.listJobAssets(jobID);
        Map<String, String> assets = jobAssets.getAvailableAssets();
        boolean isAppium = this.getJobDetails((String)jobID).automationBackend.equalsIgnoreCase(AutomationBackend.APPIUM.label);
        for (Map.Entry<String, String> entry : assets.entrySet()) {
            String assetLabel;
            String filename = assetLabel = entry.getValue();
            if (assetLabel.equals("selenium-server.log")) {
                filename = isAppium ? TestAsset.APPIUM_LOG.label : TestAsset.SELENIUM_LOG.label;
            }
            Path assetPath = path.resolve(filename);
            this.downloadJobAsset(jobID, assetPath, TestAsset.get(assetLabel).get());
        }
        Path screenshotsPath = path.resolve("screenshots.zip");
        this.downloadAllScreenshots(jobID, screenshotsPath);
    }

    public void downloadServerLog(String jobID, Path path) throws IOException {
        path = this.getJobDetails((String)jobID).automationBackend.equalsIgnoreCase(AutomationBackend.APPIUM.label) ? path.resolveSibling(TestAsset.APPIUM_LOG.label) : path.resolveSibling(TestAsset.SELENIUM_LOG.label);
        this.downloadJobAsset(jobID, path, TestAsset.SELENIUM_LOG);
    }

    public List<HashMap<String, Integer>> deleteJobAssets(String jobID) throws IOException {
        String url = this.getBaseEndpoint() + jobID + "/assets";
        return this.deserializeJSONObject(this.request(url, HttpMethod.DELETE), List.class);
    }

    public Job changeName(String jobID, String testName) throws IOException {
        return this.updateJob(jobID, new UpdateJobParameter.Builder().setName(testName).build());
    }

    public Job changeBuild(String jobID, String buildName) throws IOException {
        return this.updateJob(jobID, new UpdateJobParameter.Builder().setBuild(buildName).build());
    }

    public Job changeVisibility(String jobID, JobVisibility visibility) throws IOException {
        return this.updateJob(jobID, new UpdateJobParameter.Builder().setVisibility(visibility).build());
    }

    public Job changeResults(String jobID, Boolean passed) throws IOException {
        return this.updateJob(jobID, new UpdateJobParameter.Builder().setPassed(passed).build());
    }

    public Job passed(String jobID) throws IOException {
        return this.updateJob(jobID, new UpdateJobParameter.Builder().setPassed(true).build());
    }

    public Job failed(String jobID) throws IOException {
        return this.updateJob(jobID, new UpdateJobParameter.Builder().setPassed(false).build());
    }

    public Job addTags(String jobID, List<String> tagsList) throws IOException {
        return this.updateJob(jobID, new UpdateJobParameter.Builder().setTags(tagsList).build());
    }

    public Job addCustomData(String jobID, Map<String, String> customData) throws IOException {
        return this.updateJob(jobID, new UpdateJobParameter.Builder().setCustomData(customData).build());
    }

    @Override
    protected String getBaseEndpoint() {
        return super.getBaseEndpoint() + "rest/v1/" + this.username + "/jobs/";
    }

    private void waitForFinishedTest(String jobID) {
        String url = this.getBaseEndpoint() + jobID + "/assets";
        Awaitility.await().ignoreExceptionsMatching(e -> e.getMessage().contains("Bad Request")).atMost(Duration.ofSeconds(60L)).pollInterval(Duration.ofSeconds(1L)).until(() -> this.request(url, HttpMethod.GET).body() != null);
    }

    private void waitForBasicTestAssets(String jobID) {
        String url = this.getBaseEndpoint() + jobID + "/assets";
        Awaitility.await().ignoreExceptionsMatching(e -> e.getClass().equals(JSONException.class)).atMost(Duration.ofMinutes(5L)).pollInterval(Duration.ofSeconds(10L)).until(() -> {
            JSONObject response = new JSONObject(this.request(url, HttpMethod.GET).body().string());
            return response.has("video") && response.has(TestAsset.SAUCE_LOG.jsonKey) && response.has("selenium-log");
        });
    }
}

