/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest.api;

import com.saucelabs.saucerest.DataCenter;
import com.saucelabs.saucerest.HttpMethod;
import com.saucelabs.saucerest.LogEntry;
import com.saucelabs.saucerest.MoshiSingleton;
import com.saucelabs.saucerest.TestAsset;
import com.saucelabs.saucerest.api.AbstractEndpoint;
import com.saucelabs.saucerest.model.realdevices.AvailableDevices;
import com.saucelabs.saucerest.model.realdevices.Concurrency;
import com.saucelabs.saucerest.model.realdevices.Device;
import com.saucelabs.saucerest.model.realdevices.DeviceJob;
import com.saucelabs.saucerest.model.realdevices.DeviceJobs;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.Moshi;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import okhttp3.Response;
import okio.BufferedSource;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealDevicesEndpoint
extends AbstractEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(RealDevicesEndpoint.class);

    public RealDevicesEndpoint(DataCenter dataCenter) {
        super(dataCenter);
    }

    public RealDevicesEndpoint(String apiServer) {
        super(apiServer);
    }

    public RealDevicesEndpoint(String username, String accessKey, DataCenter dataCenter) {
        super(username, accessKey, dataCenter);
    }

    public RealDevicesEndpoint(String username, String accessKey, String apiServer) {
        super(username, accessKey, apiServer);
    }

    public List<Device> getDevices() throws IOException {
        String url = this.getBaseEndpoint() + "/devices";
        return this.deserializeJSONArray(this.request(url, HttpMethod.GET), Device.class);
    }

    public Device getSpecificDevice(String deviceID) throws IOException {
        String url = this.getBaseEndpoint() + "/devices/" + deviceID;
        return this.deserializeJSONObject(this.request(url, HttpMethod.GET), Device.class);
    }

    public AvailableDevices getAvailableDevices() throws IOException {
        String url = this.getBaseEndpoint() + "/devices/available";
        return new AvailableDevices(this.deserializeJSONArray(this.request(url, HttpMethod.GET), String.class));
    }

    public DeviceJobs getDeviceJobs() throws IOException {
        String url = this.getBaseEndpoint() + "/jobs";
        return this.deserializeJSONObject(this.request(url, HttpMethod.GET), DeviceJobs.class);
    }

    public DeviceJobs getDeviceJobs(Map<String, Object> params) throws IOException {
        String url = this.getBaseEndpoint() + "/jobs";
        return this.deserializeJSONObject(this.requestWithQueryParameters(url, HttpMethod.GET, params), DeviceJobs.class);
    }

    public DeviceJob getSpecificDeviceJob(String jobID) throws IOException {
        String url = this.getBaseEndpoint() + "/jobs/" + jobID;
        return this.deserializeJSONObject(this.request(url, HttpMethod.GET), DeviceJob.class);
    }

    public void deleteSpecificRealDeviceJob(String jobID) {
        String url = this.getBaseEndpoint() + "/jobs/" + jobID;
        try {
            this.request(url, HttpMethod.DELETE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Concurrency getConcurrency() throws IOException {
        String url = this.getBaseEndpoint() + "/concurrency";
        return this.deserializeJSONObject(this.request(url, HttpMethod.GET), Concurrency.class);
    }

    public void downloadVideo(String jobID, String path) throws IOException {
        String url = this.retryUntilTestAssetAvailable((DeviceJob)this.getSpecificDeviceJob((String)jobID), (TestAsset)TestAsset.VIDEO).videoUrl;
        this.downloadFile(url, path, TestAsset.VIDEO.label);
    }

    public void downloadHARFile(String jobID, String path) throws IOException {
        String url = this.retryUntilTestAssetAvailable((DeviceJob)this.getSpecificDeviceJob((String)jobID), (TestAsset)TestAsset.HAR).networkLogUrl;
        this.downloadFile(url, path, TestAsset.HAR.label);
    }

    public void downloadAppiumLog(String jobID, String path) throws IOException {
        String url = this.retryUntilTestAssetAvailable((DeviceJob)this.getSpecificDeviceJob((String)jobID), (TestAsset)TestAsset.APPIUM_LOG).frameworkLogUrl;
        Path directoryPath = this.getDirectoryPath(path);
        Path filePath = this.getFilePath(directoryPath, TestAsset.APPIUM_LOG.label);
        this.downloadNonMalformedLog(filePath, this.request(url, HttpMethod.GET));
    }

    public void downloadDeviceLog(String jobID, String path) throws IOException {
        String url = this.retryUntilTestAssetAvailable((DeviceJob)this.getSpecificDeviceJob((String)jobID), (TestAsset)TestAsset.DEVICE_LOG).deviceLogUrl;
        Path directoryPath = this.getDirectoryPath(path);
        Path filePath = this.getFilePath(directoryPath, TestAsset.DEVICE_LOG.label);
        this.downloadNonMalformedLog(filePath, this.request(url, HttpMethod.GET));
    }

    public void downloadCommandsLog(String jobID, String path) throws IOException {
        String url = this.retryUntilTestAssetAvailable((DeviceJob)this.getSpecificDeviceJob((String)jobID), (TestAsset)TestAsset.COMMANDS_LOG).requestsUrl;
        Path directoryPath = this.getDirectoryPath(path);
        this.downloadFile(url, directoryPath.toString(), TestAsset.COMMANDS_LOG.label);
    }

    public void downloadDeviceVitals(String jobID, String path) throws IOException {
        String url = this.retryUntilTestAssetAvailable((DeviceJob)this.getSpecificDeviceJob((String)jobID), (TestAsset)TestAsset.INSIGHTS_LOG).testfairyLogUrl;
        this.downloadFile(url, path, TestAsset.INSIGHTS_LOG.label);
    }

    public void downloadScreenshots(String jobID, String path) throws IOException {
        List<Object> list = this.retryUntilTestAssetAvailable((DeviceJob)this.getSpecificDeviceJob((String)jobID), (TestAsset)TestAsset.SCREENSHOTS).screenshots;
        for (int i = 0; i < list.size(); ++i) {
            Object pairs = list.get(i);
            String url = (String)((Map)pairs).get("url");
            this.downloadFile(url, path, i + ".png");
        }
    }

    public String getAppiumServerVersion(String jobID) throws IOException {
        String url = this.retryUntilTestAssetAvailable((DeviceJob)this.getSpecificDeviceJob((String)jobID), (TestAsset)TestAsset.APPIUM_LOG).frameworkLogUrl;
        RetryPolicy retryPolicy = ((RetryPolicy)new RetryPolicy().handleResultIf(Objects::isNull)).withMaxRetries(5).withDelay(Duration.ofSeconds(20L));
        String appiumVersion = (String)Failsafe.with((Policy)retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> {
            List<String> logEntries = this.getLogEntries(url);
            return RealDevicesEndpoint.extractAppiumVersion(logEntries);
        });
        if (appiumVersion != null) {
            return appiumVersion;
        }
        LOGGER.warn("Appium version not found in the log file");
        return null;
    }

    private List<String> getLogEntries(String url) throws IOException {
        ArrayList<String> logEntries = new ArrayList<String>();
        try (Response response = this.request(url, HttpMethod.GET);){
            String line;
            if (response == null || response.body() == null) {
                LOGGER.warn("Response or response body is null for {}", (Object)url);
                List<String> list = null;
                return list;
            }
            String responseBody = response.body().string();
            Moshi moshi = new Moshi.Builder().build();
            JsonAdapter adapter = moshi.adapter(LogEntry.class);
            BufferedReader reader = new BufferedReader(new StringReader(responseBody));
            while ((line = reader.readLine()) != null) {
                try {
                    LogEntry logEntry = (LogEntry)adapter.fromJson(line);
                    if (logEntry == null || logEntry.getTime() == null || logEntry.getLevel() == null || logEntry.getMessage() == null) continue;
                    logEntries.add(String.valueOf(logEntry) + System.lineSeparator());
                }
                catch (JsonDataException e) {
                    LOGGER.warn("Failed to parse line: {}, error: {}", (Object)line, (Object)e.getMessage());
                }
            }
        }
        return logEntries;
    }

    private static String extractAppiumVersion(List<String> versions) {
        String regex = "Appium v(\\d+\\.\\d+\\.\\d+)";
        Pattern pattern = Pattern.compile(regex);
        for (String line : versions) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            return matcher.group(1);
        }
        return null;
    }

    @Override
    protected String getBaseEndpoint() {
        return super.getBaseEndpoint() + "v1/rdc";
    }

    private DeviceJob retryUntilTestAssetAvailable(DeviceJob deviceJob, TestAsset testAsset) throws IOException {
        try {
            Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(1L, TimeUnit.MINUTES).until(this.testAssetAvailable(deviceJob, testAsset));
        }
        catch (ConditionTimeoutException e) {
            LOGGER.error("Timed out waiting for {} to be available for ID {}", (Object)testAsset.label, (Object)deviceJob.id);
        }
        return this.getSpecificDeviceJob(deviceJob.id);
    }

    private Callable<Boolean> testAssetAvailable(DeviceJob deviceJob, TestAsset testAsset) {
        return () -> {
            switch (testAsset) {
                case VIDEO: {
                    return this.getSpecificDeviceJob((String)deviceJob.id).videoUrl != null;
                }
                case HAR: {
                    return this.getSpecificDeviceJob((String)deviceJob.id).networkLogUrl != null;
                }
                case APPIUM_LOG: {
                    return this.getSpecificDeviceJob((String)deviceJob.id).frameworkLogUrl != null;
                }
                case INSIGHTS_LOG: {
                    return this.getSpecificDeviceJob((String)deviceJob.id).testfairyLogUrl != null;
                }
                case CRASH_LOG: {
                    return this.getSpecificDeviceJob((String)deviceJob.id).crashLogUrl != null;
                }
                case DEVICE_LOG: {
                    return this.getSpecificDeviceJob((String)deviceJob.id).deviceLogUrl != null;
                }
                case COMMANDS_LOG: {
                    return this.getSpecificDeviceJob((String)deviceJob.id).requestsUrl != null;
                }
                case SCREENSHOTS: {
                    return this.getSpecificDeviceJob((String)deviceJob.id).screenshots != null;
                }
            }
            return false;
        };
    }

    private void downloadNonMalformedLog(Path path, Response response) throws IOException {
        if (response == null) {
            LOGGER.warn("Response is null for {}", (Object)path);
            throw new IOException("Response is null");
        }
        if (response.body() == null) {
            LOGGER.warn("Response body is null for {}", (Object)path);
            throw new IOException("Response body is null");
        }
        Moshi moshi = MoshiSingleton.getInstance();
        BufferedSource source = response.body().source();
        JsonReader reader = JsonReader.of((BufferedSource)source);
        reader.setLenient(true);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            JsonAdapter adapter = moshi.adapter(LogEntry.class);
            JsonReader.Token peek = reader.peek();
            if (peek == JsonReader.Token.BEGIN_ARRAY) {
                reader.beginArray();
            }
            while (reader.hasNext()) {
                JsonReader.Token token = reader.peek();
                if (token == JsonReader.Token.BEGIN_OBJECT) {
                    LogEntry logEntry = (LogEntry)adapter.fromJson(reader);
                    if (logEntry == null || logEntry.getTime() == null || logEntry.getLevel() == null || logEntry.getMessage() == null) continue;
                    writer.write(String.valueOf(logEntry) + System.lineSeparator());
                    continue;
                }
                reader.skipValue();
            }
            if (peek == JsonReader.Token.BEGIN_ARRAY) {
                reader.endArray();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to write to file {}", (Object)path);
            throw e;
        }
        catch (JsonDataException e) {
            LOGGER.warn("Failed to parse JSON response: {}", (Object)e.getMessage());
            throw e;
        }
    }
}

