/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest;

import java.util.stream.Stream;

public enum DataCenter {
    US_WEST("https://saucelabs.com/", "https://api.us-west-1.saucelabs.com/", "https://app.saucelabs.com/"),
    EU_CENTRAL("https://eu-central-1.saucelabs.com/", "https://api.eu-central-1.saucelabs.com/", "https://app.eu-central-1.saucelabs.com/");

    public final String server;
    public final String apiServer;
    public final String appServer;

    private DataCenter(String server, String apiServer, String appServer) {
        this.server = server;
        this.apiServer = apiServer;
        this.appServer = appServer;
    }

    public String server() {
        return this.server;
    }

    public String apiServer() {
        return this.apiServer;
    }

    public String edsServer() {
        return this.apiServer + "v1/eds/";
    }

    public String appServer() {
        return this.appServer;
    }

    public static DataCenter fromString(String dataCenter) {
        return Stream.of(DataCenter.values()).filter(dc -> dc.name().equalsIgnoreCase(dataCenter)).findFirst().orElse(null);
    }
}

