/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest;

import com.saucelabs.saucerest.DataCenter;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SauceShareableLink {
    private SauceShareableLink() {
        throw new IllegalStateException("Utility class");
    }

    public static String getJobAuthDigest(String username, String accessKey, String sauceJobId) {
        try {
            String key = String.format("%s:%s", username, accessKey);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(StandardCharsets.US_ASCII), "HmacMD5");
            Mac mac = Mac.getInstance("HmacMD5");
            mac.init(secretKeySpec);
            byte[] result = mac.doFinal(sauceJobId.getBytes(StandardCharsets.US_ASCII));
            return SauceShareableLink.bytesToHex(result).toLowerCase();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("Error calculating job auth digest", e);
        }
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder hexStringBuilder = new StringBuilder();
        Formatter formatter = new Formatter(hexStringBuilder);
        for (byte b : bytes) {
            formatter.format("%02x", b);
        }
        return hexStringBuilder.toString();
    }

    public static String getShareableLink(String sauceJobId, DataCenter dataCenter) {
        return SauceShareableLink.getShareableLink(null, null, sauceJobId, dataCenter);
    }

    public static String getShareableLink(String username, String accessKey, String sauceJobId, DataCenter dataCenter) {
        String defaultUsername = System.getenv("SAUCE_USERNAME");
        String defaultAccessKey = System.getenv("SAUCE_ACCESS_KEY");
        if (username == null || username.isEmpty()) {
            if (defaultUsername == null || defaultUsername.isEmpty()) {
                throw new IllegalArgumentException("Sauce Labs username cannot be null or empty");
            }
            username = defaultUsername;
        }
        if (accessKey == null || accessKey.isEmpty()) {
            if (defaultAccessKey == null || defaultAccessKey.isEmpty()) {
                throw new IllegalArgumentException("Sauce Labs access key cannot be null or empty");
            }
            accessKey = defaultAccessKey;
        }
        if (sauceJobId == null || sauceJobId.isEmpty()) {
            throw new IllegalArgumentException("Sauce Labs job ID cannot be null or empty");
        }
        if (dataCenter == null) {
            throw new IllegalArgumentException("Sauce Labs data center endpoint cannot be null");
        }
        String digest = SauceShareableLink.getJobAuthDigest(username, accessKey, sauceJobId);
        return dataCenter.appServer + "tests/" + sauceJobId + "?auth=" + digest;
    }
}

