/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest.api;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.saucelabs.saucerest.BuildUtils;
import com.saucelabs.saucerest.DataCenter;
import com.saucelabs.saucerest.ErrorExplainers;
import com.saucelabs.saucerest.HttpMethod;
import com.saucelabs.saucerest.SauceException;
import com.saucelabs.saucerest.api.HttpClientConfig;
import com.saucelabs.saucerest.api.ResponseHandler;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEndpoint.class);
    private static final String JSON_MEDIA_TYPE = "application/json";
    private static final int MAX_RETRIES = 5;
    private static final int BACKOFF_INITIAL_DELAY = 30;
    private static final int BACKOFF_MULTIPLIER = 500;
    protected static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    private OkHttpClient httpClient;
    protected final String userAgent = "SauceREST/" + BuildUtils.getCurrentVersion();
    protected final String baseURL;
    protected final String username;
    protected final String accessKey;
    protected final String credentials;
    protected final boolean needsAuthentication;

    protected AbstractEndpoint(DataCenter dataCenter) {
        this(dataCenter, true);
    }

    protected AbstractEndpoint(DataCenter dataCenter, boolean needsAuthentication) {
        this.username = System.getenv("SAUCE_USERNAME");
        this.accessKey = System.getenv("SAUCE_ACCESS_KEY");
        this.needsAuthentication = needsAuthentication;
        this.credentials = this.needsAuthentication ? this.initializeCredentials() : null;
        this.baseURL = dataCenter.apiServer;
    }

    protected AbstractEndpoint(String apiServer) {
        this(apiServer, true);
    }

    protected AbstractEndpoint(String apiServer, boolean needsAuthentication) {
        this.username = System.getenv("SAUCE_USERNAME");
        this.accessKey = System.getenv("SAUCE_ACCESS_KEY");
        this.needsAuthentication = needsAuthentication;
        this.credentials = this.needsAuthentication ? this.initializeCredentials() : null;
        this.baseURL = apiServer;
    }

    protected AbstractEndpoint(String username, String accessKey, DataCenter dataCenter) {
        this.username = username;
        this.accessKey = accessKey;
        this.needsAuthentication = true;
        this.credentials = this.initializeCredentials();
        this.baseURL = dataCenter.apiServer;
    }

    protected AbstractEndpoint(String username, String accessKey, String apiServer) {
        this.username = username;
        this.accessKey = accessKey;
        this.needsAuthentication = true;
        this.credentials = this.initializeCredentials();
        this.baseURL = apiServer;
    }

    private String initializeCredentials() {
        if (this.username == null || this.accessKey == null) {
            LOGGER.warn("Credentials are null. Please set the SAUCE_USERNAME and SAUCE_ACCESS_KEY environment variables.");
            throw new SauceException.MissingCredentials(ErrorExplainers.missingCreds());
        }
        return Credentials.basic((String)this.username, (String)this.accessKey);
    }

    protected String getBaseEndpoint() {
        return this.baseURL;
    }

    private String buildUrl(String url, Map<String, Object> params) {
        if (url == null || url.isEmpty()) {
            throw new IllegalArgumentException("URL cannot be null or empty");
        }
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
        if (params != null) {
            for (Map.Entry<String, Object> param : params.entrySet()) {
                String key = param.getKey();
                Object value = param.getValue();
                if (value == null || value instanceof String && ((String)value).isEmpty()) continue;
                if (value instanceof String[]) {
                    for (String string : (String[])value) {
                        urlBuilder.addQueryParameter(key, string);
                    }
                    continue;
                }
                if (value instanceof Object[]) {
                    for (Object object : (Object[])value) {
                        urlBuilder.addQueryParameter(key, object.toString());
                    }
                    continue;
                }
                urlBuilder.addQueryParameter(key, value.toString());
            }
        }
        return urlBuilder.build().toString();
    }

    public Response request(String url, HttpMethod httpMethod) throws IOException {
        return this.request(url, httpMethod, null);
    }

    public Response request(String url, HttpMethod httpMethod, Object body) throws IOException {
        Request request = this.createRequest(url, httpMethod, body);
        return this.makeRequest(request);
    }

    public Response requestWithQueryParameters(String url, HttpMethod httpMethod, Map<String, Object> params) throws IOException {
        return this.request(this.buildUrl(url, params), httpMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OkHttpClient getHttpClient() {
        AbstractEndpoint abstractEndpoint = this;
        synchronized (abstractEndpoint) {
            if (this.httpClient == null) {
                this.createHttpClient(HttpClientConfig.defaultConfig());
            }
        }
        return this.httpClient;
    }

    public void createHttpClient(HttpClientConfig config) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(config.getConnectTimeout()).readTimeout(config.getReadTimeout()).writeTimeout(config.getWriteTimeout());
        if (config.getProxy() != null) {
            builder.proxy(config.getProxy());
        }
        if (config.getAuthenticator() != null) {
            builder.authenticator(config.getAuthenticator());
        }
        if (config.getInterceptor() != null) {
            builder.addInterceptor(config.getInterceptor());
        }
        this.httpClient = builder.build();
    }

    private Request createRequest(String url, HttpMethod httpMethod, Object body) {
        Request.Builder chain = new Request.Builder().url(url).header("User-Agent", this.userAgent);
        if (this.credentials != null) {
            chain.header("Authorization", this.credentials);
        }
        if (body != null) {
            MediaType mediaType = MediaType.parse((String)JSON_MEDIA_TYPE);
            RequestBody requestBody = RequestBody.create((String)(body instanceof String ? (String)body : GSON.toJson(body)), (MediaType)mediaType);
            chain.method(httpMethod.label, requestBody);
        } else {
            switch (httpMethod) {
                case POST: 
                case PUT: 
                case PATCH: {
                    chain.method(httpMethod.label, RequestBody.create((byte[])new byte[0], (MediaType)MediaType.parse((String)JSON_MEDIA_TYPE)));
                    break;
                }
                default: {
                    chain.method(httpMethod.label, null);
                }
            }
        }
        LOGGER.trace("Request {} {} with body {}", new Object[]{httpMethod.label, url, body});
        return chain.build();
    }

    protected Response makeRequest(Request request) throws IOException {
        Response response;
        try {
            response = this.getHttpClient().newCall(request).execute();
        }
        catch (IOException e) {
            LOGGER.error("Error executing request", (Throwable)e);
            throw new IOException(String.format("Error executing request: %s", e.getMessage()), e);
        }
        if (this.shouldRetryOnHttpError(response)) {
            LOGGER.debug("Retrying request {} {} because of HTTP error {}", new Object[]{request.method(), request.url(), response.code()});
            response = this.retryRequest(request);
        } else {
            LOGGER.trace("Not retrying request {} {} because of HTTP error {}", new Object[]{request.method(), request.url(), response.code()});
        }
        if (!response.isSuccessful()) {
            LOGGER.warn("Request {} {} failed with response code {} and message \"{}\"", new Object[]{request.method(), request.url(), response.code(), response.message()});
            ResponseHandler.responseHandler(this, response);
        }
        return response;
    }

    private boolean shouldRetryOnHttpError(Response response) {
        int HTTP_TOO_MANY_REQUESTS = 429;
        int HTTP_SERVER_ERROR_MIN = 500;
        int HTTP_SERVER_ERROR_MAX = 599;
        int responseCode = response.code();
        boolean isHttpError = responseCode >= 500 && responseCode <= 599;
        boolean isTooManyRequests = responseCode == 429;
        return isHttpError || isTooManyRequests;
    }

    private Response retryRequest(Request request) throws IOException {
        Response response;
        try {
            LOGGER.debug("Retrying request {} {}", (Object)request.method(), (Object)request.url());
            response = (Response)Failsafe.with((Policy)((RetryPolicyBuilder)RetryPolicy.builder().handle(new Class[]{RuntimeException.class, IOException.class, IllegalStateException.class})).withBackoff(30L, 500L, ChronoUnit.MILLIS).withMaxRetries(5).onRetry(e -> {
                Throwable lastException = e.getLastException();
                if (lastException != null) {
                    LOGGER.warn("Retrying because of: {}", (Object)lastException.getClass().getSimpleName());
                } else {
                    LOGGER.warn("Retrying");
                }
            }).build(), (Policy[])new RetryPolicy[0]).get(() -> this.getHttpClient().newCall(request).execute());
        }
        catch (Exception e2) {
            LOGGER.error("Error retrying request", (Throwable)e2);
            throw new IOException(String.format("Error retrying request: %s", e2.getMessage()), e2);
        }
        LOGGER.debug("Request {} {} succeeded after retry", (Object)request.method(), (Object)request.url());
        return response;
    }

    protected <T> List<T> deserializeListFromJSONObject(Response response, Class<T> elementClass) throws IOException {
        Type type = TypeToken.getParameterized(Map.class, (Type[])new Type[]{Object.class, TypeToken.getParameterized(List.class, (Type[])new Type[]{elementClass}).getType()}).getType();
        Map fullJson = (Map)this.deserializeJSON(response, type);
        return (List)fullJson.values().iterator().next();
    }

    protected <T> T deserializeJSONObject(Response response, Class<T> clazz) throws IOException {
        return this.deserializeJSON(response, clazz);
    }

    protected <T> List<T> deserializeJSONArray(Response response, Class<T> elementClass) throws IOException {
        return (List)this.deserializeJSON(response, TypeToken.getParameterized(List.class, (Type[])new Type[]{elementClass}).getType());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T deserializeJSON(Response response, Type typeOfT) throws IOException {
        if (response.body() == null) {
            throw new IOException("Response body is null");
        }
        String jsonResponse = response.body().string();
        try (Response response2 = response;){
            Object object = GSON.fromJson(jsonResponse, typeOfT);
            return (T)object;
        }
        catch (JsonSyntaxException e) {
            LOGGER.warn("Could not deserialize JSON response: {}{}", (Object)System.lineSeparator(), (Object)jsonResponse);
            throw e;
        }
    }

    protected void downloadFile(String url, String path, String fileName) {
        try (BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)Paths.get(path, fileName).toFile()));){
            sink.writeAll((Source)Objects.requireNonNull(this.request(url, HttpMethod.GET).body()).source());
        }
        catch (IOException e) {
            LOGGER.error("Error downloading file to {} with filename {}", new Object[]{path, fileName, e});
        }
    }

    protected void downloadFile(String url, String path) {
        this.downloadFile(url, path, Paths.get(url, new String[0]).getFileName().toString());
    }

    protected Path getDirectoryPath(String directoryPathString) throws IOException {
        if (directoryPathString == null || directoryPathString.isEmpty()) {
            directoryPathString = System.getProperty("user.dir");
        }
        Path directoryPath = Paths.get(directoryPathString, new String[0]);
        Files.createDirectories(directoryPath, new FileAttribute[0]);
        return directoryPath;
    }

    protected Path getFilePath(Path directoryPath, String fileName) {
        return directoryPath.resolve(fileName);
    }
}

