/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest.api;

import com.saucelabs.saucerest.DataCenter;
import com.saucelabs.saucerest.HttpMethod;
import com.saucelabs.saucerest.JobSource;
import com.saucelabs.saucerest.api.AbstractEndpoint;
import com.saucelabs.saucerest.model.builds.Build;
import com.saucelabs.saucerest.model.builds.JobsInBuild;
import com.saucelabs.saucerest.model.builds.LookupBuildsParameters;
import com.saucelabs.saucerest.model.builds.LookupJobsParameters;
import java.io.IOException;
import java.util.List;

public class BuildsEndpoint
extends AbstractEndpoint {
    public BuildsEndpoint(DataCenter dataCenter) {
        super(dataCenter);
    }

    public BuildsEndpoint(String apiServer) {
        super(apiServer);
    }

    public BuildsEndpoint(String username, String accessKey, DataCenter dataCenter) {
        super(username, accessKey, dataCenter);
    }

    public BuildsEndpoint(String username, String accessKey, String apiServer) {
        super(username, accessKey, apiServer);
    }

    public List<Build> lookupBuilds(JobSource jobSource) throws IOException {
        String url = this.getBaseEndpoint(jobSource);
        return this.deserializeListFromJSONObject(this.request(url, HttpMethod.GET), Build.class);
    }

    public List<Build> lookupBuilds(JobSource jobSource, LookupBuildsParameters parameters) throws IOException {
        String url = this.getBaseEndpoint(jobSource);
        return this.deserializeListFromJSONObject(this.requestWithQueryParameters(url, HttpMethod.GET, parameters.toMap()), Build.class);
    }

    public JobsInBuild lookupJobsForBuild(JobSource jobSource, String buildID, LookupJobsParameters parameters) throws IOException {
        String url = this.getBaseEndpoint(jobSource) + buildID + "/jobs/";
        return this.deserializeJSONObject(this.requestWithQueryParameters(url, HttpMethod.GET, parameters.toMap()), JobsInBuild.class);
    }

    public Build getSpecificBuild(JobSource jobSource, String buildID) throws IOException {
        String url = this.getBaseEndpoint(jobSource) + buildID + "/";
        return this.deserializeJSONObject(this.request(url, HttpMethod.GET), Build.class);
    }

    protected String getBaseEndpoint(JobSource jobSource) {
        return super.getBaseEndpoint() + "v2/builds/" + jobSource.value + "/";
    }
}

