/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest.api;

import java.net.Proxy;
import java.time.Duration;
import okhttp3.Authenticator;
import okhttp3.Interceptor;

public class HttpClientConfig {
    private final Duration connectTimeout;
    private final Duration readTimeout;
    private final Duration writeTimeout;
    private final Proxy proxy;
    private final Authenticator authenticator;
    private final Interceptor interceptor;

    protected HttpClientConfig(Duration connectTimeout, Duration readTimeout, Duration writeTimeout, Proxy proxy, Authenticator authenticator, Interceptor interceptor) {
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
        this.proxy = proxy;
        this.authenticator = authenticator;
        this.interceptor = interceptor;
    }

    public static HttpClientConfig defaultConfig() {
        return new HttpClientConfig(Duration.ofSeconds(300L), Duration.ofSeconds(300L), Duration.ofSeconds(300L), null, null, null);
    }

    public HttpClientConfig connectTimeout(Duration connectTimeout) {
        return new HttpClientConfig(connectTimeout, this.readTimeout, this.writeTimeout, this.proxy, this.authenticator, this.interceptor);
    }

    public HttpClientConfig readTimeout(Duration readTimeout) {
        return new HttpClientConfig(this.connectTimeout, readTimeout, this.writeTimeout, this.proxy, this.authenticator, this.interceptor);
    }

    public HttpClientConfig writeTimeout(Duration writeTimeout) {
        return new HttpClientConfig(this.connectTimeout, this.readTimeout, writeTimeout, this.proxy, this.authenticator, this.interceptor);
    }

    public HttpClientConfig proxy(Proxy proxy) {
        return new HttpClientConfig(this.connectTimeout, this.readTimeout, this.writeTimeout, proxy, this.authenticator, this.interceptor);
    }

    public HttpClientConfig authenticator(Authenticator authenticator) {
        return new HttpClientConfig(this.connectTimeout, this.readTimeout, this.writeTimeout, this.proxy, authenticator, this.interceptor);
    }

    public HttpClientConfig interceptor(Interceptor interceptor) {
        return new HttpClientConfig(this.connectTimeout, this.readTimeout, this.writeTimeout, this.proxy, this.authenticator, interceptor);
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public Duration getWriteTimeout() {
        return this.writeTimeout;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }
}

