/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest.api;

import com.google.gson.reflect.TypeToken;
import com.saucelabs.saucerest.DataCenter;
import com.saucelabs.saucerest.HttpMethod;
import com.saucelabs.saucerest.api.AbstractEndpoint;
import com.saucelabs.saucerest.model.platform.AppiumVersion;
import com.saucelabs.saucerest.model.platform.EndOfLifeAppiumVersions;
import com.saucelabs.saucerest.model.platform.Platform;
import com.saucelabs.saucerest.model.platform.SupportedPlatforms;
import com.saucelabs.saucerest.model.platform.TestStatus;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.stream.Collectors;

public class PlatformEndpoint
extends AbstractEndpoint {
    public PlatformEndpoint(DataCenter dataCenter) {
        super(dataCenter, false);
    }

    public PlatformEndpoint(String apiServer) {
        super(apiServer, false);
    }

    public PlatformEndpoint(String username, String accessKey, DataCenter dataCenter) {
        super(username, accessKey, dataCenter);
    }

    public PlatformEndpoint(String username, String accessKey, String apiServer) {
        super(username, accessKey, apiServer);
    }

    public TestStatus getTestStatus() throws IOException {
        String url = this.getBaseEndpoint() + "/status";
        return this.deserializeJSONObject(this.request(url, HttpMethod.GET), TestStatus.class);
    }

    public SupportedPlatforms getSupportedPlatforms(String automationApi) throws IOException {
        String url = this.getBaseEndpoint() + "/platforms/" + automationApi;
        return new SupportedPlatforms(this.deserializeJSONArray(this.request(url, HttpMethod.GET), Platform.class));
    }

    public EndOfLifeAppiumVersions getEndOfLifeAppiumVersions() throws IOException {
        String url = this.getBaseEndpoint() + "/platforms/appium/eol";
        Type type = TypeToken.getParameterized(Map.class, (Type[])new Type[]{String.class, Integer.class}).getType();
        Map mapOfVersions = (Map)this.deserializeJSON(this.request(url, HttpMethod.GET), type);
        return new EndOfLifeAppiumVersions(mapOfVersions.entrySet().stream().map(entry -> new AppiumVersion((String)entry.getKey(), (Integer)entry.getValue())).collect(Collectors.toList()));
    }

    @Override
    protected String getBaseEndpoint() {
        return super.getBaseEndpoint() + "rest/v1/info";
    }
}

