/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest.api;

import com.saucelabs.saucerest.DataCenter;
import com.saucelabs.saucerest.HttpMethod;
import com.saucelabs.saucerest.api.AbstractEndpoint;
import com.saucelabs.saucerest.model.storage.DeleteAppFile;
import com.saucelabs.saucerest.model.storage.DeleteAppGroupFiles;
import com.saucelabs.saucerest.model.storage.EditAppGroupSettings;
import com.saucelabs.saucerest.model.storage.EditFileDescription;
import com.saucelabs.saucerest.model.storage.GetAppFiles;
import com.saucelabs.saucerest.model.storage.GetAppStorageGroupSettings;
import com.saucelabs.saucerest.model.storage.GetAppStorageGroups;
import com.saucelabs.saucerest.model.storage.UploadFileApp;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageEndpoint
extends AbstractEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageEndpoint.class);

    public StorageEndpoint(DataCenter dataCenter) {
        super(dataCenter);
    }

    public StorageEndpoint(String apiServer) {
        super(apiServer);
    }

    public StorageEndpoint(String username, String accessKey, DataCenter dataCenter) {
        super(username, accessKey, dataCenter);
    }

    public StorageEndpoint(String username, String accessKey, String apiServer) {
        super(username, accessKey, apiServer);
    }

    public GetAppFiles getFiles() throws IOException {
        String url = this.getBaseEndpoint() + "/files";
        return this.deserializeJSONObject(this.request(url, HttpMethod.GET), GetAppFiles.class);
    }

    public GetAppFiles getFiles(Map<String, Object> params) throws IOException {
        String url = this.getBaseEndpoint() + "/files";
        return this.deserializeJSONObject(this.requestWithQueryParameters(url, HttpMethod.GET, params), GetAppFiles.class);
    }

    public GetAppStorageGroups getGroups() throws IOException {
        String url = this.getBaseEndpoint() + "/groups";
        return this.deserializeJSONObject(this.request(url, HttpMethod.GET), GetAppStorageGroups.class);
    }

    public GetAppStorageGroups getGroups(Map<String, Object> params) throws IOException {
        String url = this.getBaseEndpoint() + "/groups";
        return this.deserializeJSONObject(this.requestWithQueryParameters(url, HttpMethod.GET, params), GetAppStorageGroups.class);
    }

    public GetAppStorageGroupSettings getGroupSettings(int groupId) throws IOException {
        String url = this.getBaseEndpoint() + "/groups/" + groupId + "/settings";
        return this.deserializeJSONObject(this.request(url, HttpMethod.GET), GetAppStorageGroupSettings.class);
    }

    public EditAppGroupSettings updateAppStorageGroupSettings(int groupId, EditAppGroupSettings editAppGroupSettings) throws IOException {
        String url = this.getBaseEndpoint() + "/groups/" + groupId + "/settings";
        return this.deserializeJSONObject(this.request(url, HttpMethod.PUT, editAppGroupSettings), EditAppGroupSettings.class);
    }

    public UploadFileApp uploadFile(File file) throws IOException {
        return this.uploadFile(file, "", "");
    }

    public UploadFileApp uploadFile(File file, String fileName) throws IOException {
        return this.uploadFile(file, fileName, "");
    }

    public UploadFileApp uploadFile(File file, String fileName, String description) throws IOException {
        String url = this.getBaseEndpoint() + "/upload";
        return this.deserializeJSONObject(this.postMultipartResponse(url, file, fileName, description), UploadFileApp.class);
    }

    public void downloadFile(String fileId, Path path) throws IOException {
        String url = this.getBaseEndpoint() + "/download/" + fileId;
        try (BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)path.toFile()));){
            sink.writeAll((Source)Objects.requireNonNull(this.request(url, HttpMethod.GET).body()).source());
        }
    }

    public EditFileDescription updateFileDescription(String fileId, String description) throws IOException {
        String url = this.getBaseEndpoint() + "/files/" + fileId;
        Map<String, Map<String, String>> map = Map.of("item", Map.of("description", description));
        return this.deserializeJSONObject(this.request(url, HttpMethod.PUT, map), EditFileDescription.class);
    }

    public DeleteAppFile deleteFile(String fileId) throws IOException {
        String url = this.getBaseEndpoint() + "/files/" + fileId;
        return this.deserializeJSONObject(this.request(url, HttpMethod.DELETE), DeleteAppFile.class);
    }

    public DeleteAppGroupFiles deleteFileGroup(int groupId) throws IOException {
        String url = this.getBaseEndpoint() + "/groups/" + groupId;
        return this.deserializeJSONObject(this.request(url, HttpMethod.DELETE), DeleteAppGroupFiles.class);
    }

    @Override
    protected String getBaseEndpoint() {
        return super.getBaseEndpoint() + "v1/storage";
    }

    private Response postMultipartResponse(String url, File file, String fileName, String description) throws IOException {
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("name", fileName).addFormDataPart("description", description).addFormDataPart("payload", file.getName(), RequestBody.create((File)file, (MediaType)MediaType.parse((String)"application/octet-stream"))).build();
        Request request = new Request.Builder().header("Authorization", this.credentials).url(url).post((RequestBody)requestBody).build();
        Response response = this.makeRequest(request);
        if (!response.isSuccessful()) {
            if (response.body() != null) {
                LOGGER.error("Error uploading file: {}", (Object)response.body().string());
            }
            throw new IOException("Unexpected code" + String.valueOf(response));
        }
        return response;
    }
}

