/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.saucerest.model.insights;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;

public class TestResultParameter {
    private final String build;
    private final Boolean build_missing;
    private final Boolean descending;
    private final String end;
    private final String error;
    private final String name;
    private final int from;
    private final String owner;
    private final Scope scope;
    private final int size;
    private final String start;
    private final Status[] status;
    private final TimeRange time_range;

    private TestResultParameter(Builder builder) {
        this.build = builder.build;
        this.build_missing = builder.build_missing;
        this.descending = builder.descending;
        this.end = builder.end;
        this.error = builder.error;
        this.name = builder.name;
        this.from = builder.from;
        this.owner = builder.owner;
        this.scope = builder.scope;
        this.size = builder.size;
        this.start = builder.start;
        this.status = builder.status;
        this.time_range = builder.time_range;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.build != null) {
            parameters.put("build", this.build);
        }
        if (this.build_missing != null) {
            parameters.put("build_missing", this.build_missing);
        }
        if (this.descending != null) {
            parameters.put("descending", this.descending);
        }
        if (this.end != null) {
            parameters.put("end", this.end);
        }
        if (this.error != null) {
            parameters.put("error", this.error);
        }
        if (this.name != null) {
            parameters.put("name", this.name);
        }
        if (this.from != 0) {
            parameters.put("from", this.from);
        }
        if (this.owner != null) {
            parameters.put("owner", this.owner);
        }
        if (this.scope != null) {
            parameters.put("scope", this.scope.getValue());
        }
        if (this.size != 0) {
            parameters.put("size", this.size);
        }
        if (this.start != null) {
            parameters.put("start", this.start);
        }
        if (this.status != null) {
            parameters.put("status", this.status);
        }
        if (this.time_range != null) {
            parameters.put("time_range", this.time_range.toString());
        }
        return parameters;
    }

    public static final class Builder {
        private String build;
        private Boolean build_missing;
        private Boolean descending;
        private String end;
        private String error;
        private String name;
        private int from;
        private String owner;
        private Scope scope;
        private int size;
        private String start;
        private Status[] status;
        private TimeRange time_range;

        public Builder setBuild(String val) {
            this.build = val;
            return this;
        }

        public Builder setBuild_missing(Boolean val) {
            this.build_missing = val;
            return this;
        }

        public Builder setDescending(Boolean val) {
            this.descending = val;
            return this;
        }

        public Builder setEnd(LocalDateTime val) {
            ZoneOffset offset = ZoneId.systemDefault().getRules().getOffset(val);
            LocalDateTime utcDateTime = val.minusSeconds(offset.getTotalSeconds());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
            this.end = utcDateTime.format(formatter);
            return this;
        }

        public Builder setError(String val) {
            this.error = val;
            return this;
        }

        public Builder setName(String val) {
            this.name = val;
            return this;
        }

        public Builder setFrom(int val) {
            this.from = val;
            return this;
        }

        public Builder setOwner(String val) {
            this.owner = val;
            return this;
        }

        public Builder setScope(Scope val) {
            this.scope = val;
            return this;
        }

        public Builder setSize(int val) {
            this.size = val;
            return this;
        }

        public Builder setStart(LocalDateTime val) {
            ZoneOffset offset = ZoneId.systemDefault().getRules().getOffset(val);
            LocalDateTime utcDateTime = val.minusSeconds(offset.getTotalSeconds());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
            this.start = utcDateTime.format(formatter);
            return this;
        }

        public Builder setStatus(Status[] val) {
            this.status = val;
            return this;
        }

        public Builder setTime_range(TimeRange val) {
            this.time_range = val;
            return this;
        }

        public TestResultParameter build() {
            boolean isStartEndUsed;
            boolean isTimeRangeUsed = this.time_range != null;
            boolean bl = isStartEndUsed = this.start != null && this.end != null;
            if (!isTimeRangeUsed && !isStartEndUsed) {
                throw new IllegalStateException("Either 'time_range' or 'start' and 'end' must be set.");
            }
            if (isTimeRangeUsed && isStartEndUsed) {
                throw new IllegalStateException("Only one of 'time_range' or 'start' and 'end' can be set, not both.");
            }
            if (isStartEndUsed && !this.isStartBeforeEnd().booleanValue()) {
                throw new IllegalStateException("'start' must be before 'end'.");
            }
            if (this.size == 0) {
                this.size = 10;
            }
            return new TestResultParameter(this);
        }

        private Boolean isStartBeforeEnd() {
            LocalDateTime dateTime2;
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
            LocalDateTime dateTime1 = LocalDateTime.parse(this.start, formatter);
            if (dateTime1.isBefore(dateTime2 = LocalDateTime.parse(this.end, formatter))) {
                return true;
            }
            return false;
        }
    }

    public static enum Scope {
        ME("me"),
        ORGANIZATION("organization"),
        SINGLE("single");

        private final String value;

        private Scope(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Status {
        PASSED("passed"),
        ERRORED("errored"),
        FAILED("failed"),
        COMPLETE("complete");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class TimeRange {
        private final int value;
        private final Unit unit;

        public TimeRange(int value, Unit unit) {
            this.value = value;
            this.unit = unit;
        }

        public String toString() {
            return String.format("%d%s", this.value, this.unit.getValue());
        }
    }

    public static enum Unit {
        D("d"),
        H("h"),
        M("m"),
        S("s");

        private final String value;

        private Unit(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

