/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.sauce_ondemand.driver;

import com.saucelabs.rest.Credential;
import com.saucelabs.sauce_ondemand.driver.SauceOnDemandSelenium;
import com.thoughtworks.selenium.DefaultSelenium;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import sun.misc.BASE64Encoder;

class SeleniumImpl
extends DefaultSelenium
implements SauceOnDemandSelenium {
    private String lastSessionId;
    private final Credential credential;

    SeleniumImpl(String serverHost, int serverPort, String browserStartCommand, String browserURL, Credential credential) {
        super(serverHost, serverPort, browserStartCommand, browserURL);
        this.credential = credential;
    }

    public void start() {
        super.start();
        this.dumpSessionId();
    }

    public void start(String optionsString) {
        super.start(optionsString);
        this.dumpSessionId();
    }

    public void start(Object optionsObject) {
        super.start(optionsObject);
        this.dumpSessionId();
    }

    private void dumpSessionId() {
        this.lastSessionId = this.getSessionId();
        System.out.println("SauceOnDemandSessionID=" + this.lastSessionId);
    }

    public String getSessionId() {
        try {
            Field f = this.commandProcessor.getClass().getDeclaredField("sessionId");
            f.setAccessible(true);
            Object id = f.get(this.commandProcessor);
            if (id != null) {
                return id.toString();
            }
            return this.lastSessionId;
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public URL getSeleniumServerLogFile() throws IOException {
        return this.getFileURL("selenium-server.log");
    }

    public URL getVideo() throws IOException {
        return this.getFileURL("video.flv");
    }

    private URL getFileURL(String fileName) throws MalformedURLException {
        return new URL(MessageFormat.format("https://saucelabs.com/rest/{0}/jobs/{1}/results/{2}", this.credential.getUsername(), this.lastSessionId, fileName));
    }

    public InputStream getSeleniumServerLogFileInputStream() throws IOException {
        return this.openWithAuth(this.getSeleniumServerLogFile());
    }

    public InputStream getVideoInputStream() throws IOException {
        return this.openWithAuth(this.getVideo());
    }

    private InputStream openWithAuth(URL url) throws IOException {
        URLConnection con = url.openConnection();
        String encodedAuthorization = new BASE64Encoder().encode((this.credential.getUsername() + ":" + this.credential.getKey()).getBytes());
        con.setRequestProperty("Authorization", "Basic " + encodedAuthorization);
        return con.getInputStream();
    }
}

