/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.selenium.client.client.factory.impl;

import com.saucelabs.selenium.client.client.factory.SeleniumFactory;
import com.saucelabs.selenium.client.client.factory.spi.SeleniumFactorySPI;
import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.Selenium;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;

public class DefaultSeleniumSPIImpl
extends SeleniumFactorySPI {
    public static final int DEFAULT_PORT = Integer.getInteger(DefaultSeleniumSPIImpl.class.getName() + ".defaultPort", 4444);

    public Selenium createSelenium(SeleniumFactory factory, String browserURL) {
        if (!factory.getUri().startsWith("http:")) {
            return null;
        }
        try {
            String browserStartCommand;
            URL url = new URL(factory.getUri());
            int p = url.getPort();
            if (p == -1) {
                p = DEFAULT_PORT;
            }
            if ((browserStartCommand = (String)factory.getProperty("browserStartCommand")) == null) {
                browserStartCommand = URLDecoder.decode(url.getPath().substring(1), "UTF-8");
            }
            return new DefaultSelenium(url.getHost(), p, browserStartCommand, browserURL);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL: " + factory.getUri(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }
}

