package com.saucelabs.visual;

import com.saucelabs.visual.VisualApi.BuildAttributes;

public class VisualBuild {
  private VisualBuild() {}

  private static volatile String buildId = null;

  public static String getOnce(VisualApi api, BuildAttributes buildAttributes) {
    synchronized (VisualBuild.class) {
      if (buildId == null) {
        buildId = api.createBuild(buildAttributes);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> api.finishBuild(buildId)));
      }
    }
    return buildId;
  }
}
