package com.saucelabs.visual;

import com.saucelabs.visual.VisualApi.BuildAttributes;

public class VisualBuild {

  private final String id;

  private final String name;

  private final String project;
  private final String branch;

  private final String url;

  VisualBuild(String id, String name, String project, String branch, String url) {
    this.id = id;
    this.name = name;
    this.project = project;
    this.branch = branch;
    this.url = url;
  }

  public String getId() {
    return id;
  }

  public String getName() {
    return name;
  }

  public String getProject() {
    return project;
  }

  public String getBranch() {
    return branch;
  }

  public String getUrl() {
    return url;
  }

  private static volatile VisualBuild build = null;

  public static VisualBuild getBuildOnce(VisualApi api, BuildAttributes buildAttributes) {
    synchronized (VisualBuild.class) {
      if (build == null) {
        build = api.createBuild(buildAttributes);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> api.finishBuild(build.id)));
      }
    }
    return build;
  }

  /**
   * @deprecated Use {@link #getBuildOnce(VisualApi, BuildAttributes)} instead.
   * @param api
   * @param buildAttributes
   * @return
   */
  @Deprecated
  public static String getOnce(VisualApi api, BuildAttributes buildAttributes) {
    return getBuildOnce(api, buildAttributes).getId();
  }
}
