package com.saucelabs.visual.graphql;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;

public class BuildUrlQuery implements GraphQLOperation {

  public static final String OPERATION_DOCUMENT =
      ""
          + "query build($input: UUID!) {\n"
          + "  result: build(id: $input) {\n"
          + "    url\n"
          + "  }\n"
          + "}\n";

  public static class Data {

    public final Result result;

    @JsonCreator
    public Data(@JsonProperty("result") Result result) {
      this.result = result;
    }

    @Override
    public String toString() {
      return "BuildQuery.Data{" + "result=" + result + '}';
    }
  }

  public static class Result {

    public String url;

    @JsonCreator
    public Result(@JsonProperty("url") String url) {
      this.url = url;
    }

    @Override
    public String toString() {
      return "BuildQuery.Result{" + "url='" + url + '\'' + '}';
    }
  }

  private final String input;

  public BuildUrlQuery(String input) {
    this.input = input;
  }

  @Override
  public String getQuery() {
    return OPERATION_DOCUMENT;
  }

  @Override
  public Map<String, Object> getVariables() {
    return Collections.singletonMap("input", input);
  }
}
