/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.visual;

import com.saucelabs.visual.CheckOptions;
import com.saucelabs.visual.DataCenter;
import com.saucelabs.visual.TestMetaInfo;
import com.saucelabs.visual.VisualBuild;
import com.saucelabs.visual.exception.VisualApiException;
import com.saucelabs.visual.graphql.CreateBuildMutation;
import com.saucelabs.visual.graphql.CreateSnapshotFromWebDriverMutation;
import com.saucelabs.visual.graphql.DiffsForTestResultQuery;
import com.saucelabs.visual.graphql.FinishBuildMutation;
import com.saucelabs.visual.graphql.GraphQLClient;
import com.saucelabs.visual.graphql.GraphQLOperation;
import com.saucelabs.visual.graphql.WebdriverSessionInfoQuery;
import com.saucelabs.visual.graphql.type.Diff;
import com.saucelabs.visual.graphql.type.DiffStatus;
import com.saucelabs.visual.graphql.type.DiffingMethod;
import com.saucelabs.visual.graphql.type.RegionIn;
import com.saucelabs.visual.model.IgnoreRegion;
import com.saucelabs.visual.utils.ConsoleColors;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualApi {
    private static final Logger log = LoggerFactory.getLogger(VisualApi.class);
    private final GraphQLClient client;
    private final VisualBuild build;
    private final String jobId;
    private final String sessionId;
    private final List<String> uploadedDiffIds = new ArrayList<String>();
    private String sessionMetadataBlob;

    public VisualApi(RemoteWebDriver driver, DataCenter region, String username, String accessKey) {
        this(driver, region.endpoint, username, accessKey);
    }

    public VisualApi(RemoteWebDriver driver, String url, String username, String accessKey) {
        this(driver, url, username, accessKey, new BuildAttributes(null, null, null));
    }

    public VisualApi(RemoteWebDriver driver, String url, String username, String accessKey, BuildAttributes buildAttributes) {
        if (username == null || accessKey == null || username.trim().isEmpty() || accessKey.trim().isEmpty()) {
            throw new VisualApiException("Invalid SauceLabs credentials. Please check your SauceLabs username and access key at https://app.saucelabs.com/user-settings");
        }
        this.client = new GraphQLClient(url, username, accessKey);
        this.sessionId = driver.getSessionId().toString();
        String jobIdString = (String)driver.getCapabilities().getCapability("jobUuid");
        this.jobId = jobIdString == null ? this.sessionId : jobIdString;
        this.build = VisualBuild.getBuildOnce(this, buildAttributes);
        this.sessionMetadataBlob = this.webdriverSessionInfo().blob;
    }

    VisualApi(String jobId, String sessionId, VisualBuild build, String sessionMetadataBlob, String url, String username, String accessKey) {
        if (username == null || accessKey == null || username.trim().isEmpty() || accessKey.trim().isEmpty()) {
            throw new VisualApiException("Invalid SauceLabs credentials. Please check your SauceLabs username and access key at https://app.saucelabs.com/user-settings");
        }
        this.build = build;
        this.jobId = jobId;
        this.sessionId = sessionId;
        this.client = new GraphQLClient(url, username, accessKey);
        this.sessionMetadataBlob = sessionMetadataBlob;
    }

    private WebdriverSessionInfoQuery.Result webdriverSessionInfo() {
        WebdriverSessionInfoQuery query = new WebdriverSessionInfoQuery(new WebdriverSessionInfoQuery.WebdriverSessionInfoIn(this.jobId, this.sessionId));
        return this.client.execute((GraphQLOperation)query, WebdriverSessionInfoQuery.Data.class).result;
    }

    private static String getStartupMessage(String url) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append("\n").append(ConsoleColors.Bold(ConsoleColors.Yellow("Sauce Visual\n"))).append("\n").append(String.format("%100s\n", url)).append("\n");
        return sb.toString();
    }

    VisualBuild createBuild(String buildName) {
        return this.createBuild(new BuildAttributes(buildName, null, null));
    }

    VisualBuild createBuild(BuildAttributes buildAttributes) {
        CreateBuildMutation mutation = new CreateBuildMutation(new CreateBuildMutation.BuildIn(buildAttributes.getName(), buildAttributes.getProject(), buildAttributes.getBranch()));
        CreateBuildMutation.Data data = this.client.execute(mutation, CreateBuildMutation.Data.class);
        log.info(VisualApi.getStartupMessage(data.result.url));
        return new VisualBuild(data.result.id, data.result.name, data.result.project, data.result.branch, data.result.url);
    }

    FinishBuildMutation.Result finishBuild(String buildId) {
        FinishBuildMutation mutation = new FinishBuildMutation(new FinishBuildMutation.FinishBuildIn(buildId));
        return this.client.execute((GraphQLOperation)mutation, FinishBuildMutation.Data.class).result;
    }

    public void check(String name) {
        log.warn("Method \"check()\" is deprecated and will be removed in a future version. Please use \"sauceVisualCheck()\".");
        this.sauceVisualCheck(name);
    }

    public void check(String name, CheckOptions options) {
        log.warn("Method \"check()\" is deprecated and will be removed in a future version. Please use \"sauceVisualCheck()\".");
        this.sauceVisualCheck(name, options);
    }

    public void sauceVisualCheck(String snapshotName) {
        this.sauceVisualCheck(snapshotName, new CheckOptions());
    }

    public void sauceVisualCheck(String snapshotName, CheckOptions options) {
        DiffingMethod diffingMethod = VisualApi.toDiffingMethod(options);
        CreateSnapshotFromWebDriverMutation.CreateSnapshotFromWebDriverIn input = new CreateSnapshotFromWebDriverMutation.CreateSnapshotFromWebDriverIn(this.build.getId(), diffingMethod, this.extractIgnoreList(options), this.jobId, snapshotName, this.sessionId, this.sessionMetadataBlob);
        if (options.getTestName() != null) {
            input.setTestName(options.getTestName());
        } else if (TestMetaInfo.THREAD_LOCAL.get().isPresent()) {
            input.setTestName(TestMetaInfo.THREAD_LOCAL.get().get().getTestName());
        }
        if (options.getSuiteName() != null) {
            input.setSuiteName(options.getSuiteName());
        } else if (TestMetaInfo.THREAD_LOCAL.get().isPresent()) {
            input.setSuiteName(TestMetaInfo.THREAD_LOCAL.get().get().getTestSuite());
        }
        CreateSnapshotFromWebDriverMutation mutation = new CreateSnapshotFromWebDriverMutation(input);
        CreateSnapshotFromWebDriverMutation.Data check = this.client.execute(mutation, CreateSnapshotFromWebDriverMutation.Data.class);
        if (check != null && check.result != null) {
            this.uploadedDiffIds.addAll(check.result.diffs.getNodes().stream().map(Diff::getId).collect(Collectors.toList()));
        }
    }

    private static DiffingMethod toDiffingMethod(CheckOptions options) {
        if (options == null || options.getDiffingMethod() == null) {
            return null;
        }
        switch (options.getDiffingMethod()) {
            case EXPERIMENTAL: {
                return DiffingMethod.EXPERIMENTAL;
            }
        }
        return DiffingMethod.SIMPLE;
    }

    public Map<DiffStatus, Integer> checkResults() {
        return this.sauceVisualResults();
    }

    public Map<DiffStatus, Integer> sauceVisualResults() {
        RetryPolicy retryPolicy = ((RetryPolicyBuilder)RetryPolicy.builder().handle(VisualApiException.class)).withBackoff(Duration.ofMillis(100L), Duration.ofSeconds(120L)).withMaxRetries(10).build();
        return (Map)Failsafe.with((Policy)retryPolicy, (Policy[])new RetryPolicy[0]).get(this::getDiffStatusSummary);
    }

    private Map<DiffStatus, Integer> getDiffStatusSummary() {
        HashMap<DiffStatus, Integer> initialStatusSummary = new HashMap<DiffStatus, Integer>();
        initialStatusSummary.put(DiffStatus.APPROVED, 0);
        initialStatusSummary.put(DiffStatus.EQUAL, 0);
        initialStatusSummary.put(DiffStatus.UNAPPROVED, 0);
        initialStatusSummary.put(DiffStatus.REJECTED, 0);
        initialStatusSummary.put(DiffStatus.QUEUED, 0);
        DiffsForTestResultQuery query = new DiffsForTestResultQuery(this.build.getId());
        DiffsForTestResultQuery.Data diffsForTestResult = this.client.execute(query, DiffsForTestResultQuery.Data.class);
        if (diffsForTestResult == null || diffsForTestResult.result == null) {
            return initialStatusSummary;
        }
        HashMap<DiffStatus, Integer> statusSummary = new HashMap<DiffStatus, Integer>(initialStatusSummary);
        for (DiffsForTestResultQuery.Node diff : diffsForTestResult.result.nodes) {
            if (!this.uploadedDiffIds.contains(diff.id)) continue;
            statusSummary.put(diff.status, statusSummary.getOrDefault((Object)diff.status, 0) + 1);
        }
        if ((Integer)statusSummary.get((Object)DiffStatus.QUEUED) > 0) {
            throw new VisualApiException("Some diffs are not ready");
        }
        this.uploadedDiffIds.clear();
        return statusSummary;
    }

    public void refreshWebDriverSessionInfo() {
        this.sessionMetadataBlob = this.webdriverSessionInfo().blob;
    }

    private List<RegionIn> extractIgnoreList(CheckOptions options) {
        int i;
        if (options == null) {
            return Collections.emptyList();
        }
        ArrayList<RegionIn> result = new ArrayList<RegionIn>();
        for (i = 0; i < options.getIgnoreElements().size(); ++i) {
            WebElement element = options.getIgnoreElements().get(i);
            if (this.validate(element) == null) {
                throw new VisualApiException("options.ignoreElement[" + i + "] does not exist (yet)");
            }
            result.add(this.toIgnoreIn(element));
        }
        for (i = 0; i < options.getIgnoreRegions().size(); ++i) {
            IgnoreRegion ignoreRegion = options.getIgnoreRegions().get(i);
            if (this.validate(ignoreRegion) == null) {
                throw new VisualApiException("options.ignoreRegion[" + i + "] is an invalid ignore region");
            }
            result.add(this.toIgnoreIn(ignoreRegion));
        }
        return result;
    }

    private RegionIn toIgnoreIn(WebElement element) {
        Rectangle r = element.getRect();
        return RegionIn.builder().withX(r.getX()).withY(r.getY()).withWidth(r.getWidth()).withHeight(r.getHeight()).build();
    }

    private RegionIn toIgnoreIn(IgnoreRegion r) {
        return RegionIn.builder().withX(r.getX()).withY(r.getY()).withWidth(r.getWidth()).withHeight(r.getHeight()).build();
    }

    private WebElement validate(WebElement element) {
        if (element == null || !element.isDisplayed() || element.getRect() == null) {
            return null;
        }
        return element;
    }

    private IgnoreRegion validate(IgnoreRegion region) {
        if (region == null) {
            return null;
        }
        if (region.getHeight() <= 0 || region.getWidth() <= 0) {
            return null;
        }
        return region;
    }

    public VisualBuild getBuild() {
        return this.build;
    }

    public static class BuildAttributes {
        private final String name;
        private final String project;
        private final String branch;

        public BuildAttributes(String name, String project, String branch) {
            this.name = name;
            this.project = project;
            this.branch = branch;
        }

        public String getName() {
            return this.name;
        }

        public String getProject() {
            return this.project;
        }

        public String getBranch() {
            return this.branch;
        }
    }

    public static class Builder {
        private final RemoteWebDriver driver;
        private final String username;
        private final String accessKey;
        private final String endpoint;
        private String projectName;
        private String branchName;
        private String buildName;

        public Builder(RemoteWebDriver driver, String username, String accessKey) {
            this(driver, username, accessKey, DataCenter.US_WEST_1.endpoint);
        }

        public Builder(RemoteWebDriver driver, String username, String accessKey, DataCenter region) {
            this(driver, username, accessKey, region.endpoint);
        }

        public Builder(RemoteWebDriver driver, String username, String accessKey, String endpoint) {
            this.driver = driver;
            this.username = username;
            this.accessKey = accessKey;
            this.endpoint = endpoint;
        }

        public Builder withBuild(String buildName) {
            this.buildName = buildName;
            return this;
        }

        public Builder withProject(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public Builder withBranch(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public VisualApi build() {
            if (this.buildName == null) {
                this.buildName = System.getenv("BUILD_NAME");
            }
            return new VisualApi(this.driver, this.endpoint, this.username, this.accessKey, new BuildAttributes(this.buildName, this.projectName, this.branchName));
        }
    }
}

