/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.visual.graphql;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.saucelabs.visual.graphql.GraphQLOperation;
import com.saucelabs.visual.graphql.type.DiffingMethod;
import com.saucelabs.visual.graphql.type.DiffsConnection;
import com.saucelabs.visual.graphql.type.RegionIn;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CreateSnapshotFromWebDriverMutation
implements GraphQLOperation {
    public static final String OPERATION_DOCUMENT = "mutation createSnapshotFromWebDriver($input: CreateSnapshotFromWebDriverIn!) { result: createSnapshotFromWebDriver(input: $input) { id uploadId diffs { nodes { id __typename baselineId snapshotId status diffBounds { x y width height } diffClusters { x y width height } } } } }";
    private final CreateSnapshotFromWebDriverIn input;

    public CreateSnapshotFromWebDriverMutation(CreateSnapshotFromWebDriverIn input) {
        this.input = input;
    }

    @Override
    public String getQuery() {
        return OPERATION_DOCUMENT;
    }

    @Override
    public Map<String, Object> getVariables() {
        return Collections.singletonMap("input", this.input);
    }

    public static class Result {
        public String id;
        public String uploadId;
        public DiffsConnection diffs;

        @JsonCreator
        public Result(@JsonProperty(value="id") String id, @JsonProperty(value="uploadId") String uploadId, @JsonProperty(value="diffs") DiffsConnection diffs) {
            this.id = id;
            this.uploadId = uploadId;
            this.diffs = diffs;
        }

        public String toString() {
            return "CreateSnapshotFromWebDriverMutation.Result{id='" + this.id + '\'' + ", uploadId='" + this.uploadId + '\'' + ", diffs=" + this.diffs + '}';
        }
    }

    public static class Data {
        public final Result result;

        @JsonCreator
        public Data(@JsonProperty(value="result") Result result) {
            this.result = result;
        }

        public String toString() {
            return "CreateSnapshotFromWebDriverMutation.Data{result=" + this.result + '}';
        }
    }

    public static class CreateSnapshotFromWebDriverIn {
        public final String buildUuid;
        public final DiffingMethod diffingMethod;
        public final List<RegionIn> ignoreRegions;
        public final String jobId;
        public final String name;
        public final String sessionId;
        public final String sessionMetadata;
        public Optional<String> suiteName = Optional.empty();
        public Optional<String> testName = Optional.empty();

        public CreateSnapshotFromWebDriverIn(String buildUuid, DiffingMethod diffingMethod, List<RegionIn> ignoreRegions, String jobId, String name, String sessionId, String sessionMetadata) {
            this.buildUuid = buildUuid;
            this.diffingMethod = diffingMethod;
            this.ignoreRegions = ignoreRegions;
            this.jobId = jobId;
            this.name = name;
            this.sessionId = sessionId;
            this.sessionMetadata = sessionMetadata;
        }

        public void setTestName(String testName) {
            this.testName = Optional.of(testName);
        }

        public void setSuiteName(String suiteName) {
            this.suiteName = Optional.of(suiteName);
        }
    }
}

