/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.visual.graphql;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.saucelabs.visual.exception.VisualApiException;
import com.saucelabs.visual.graphql.GraphQLOperation;
import com.saucelabs.visual.utils.ArtifactVersion;
import java.io.IOException;
import java.util.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class GraphQLClient {
    private final String uri;
    private final HttpClient client;
    private final String authentication;
    private final ObjectMapper objectMapper;

    public GraphQLClient(String uri, String username, String accessKey) {
        this((HttpClient)HttpClients.createDefault(), uri, username, accessKey);
    }

    public GraphQLClient(HttpClient client, String uri, String username, String accessKey) {
        this.client = client;
        this.uri = uri;
        this.authentication = Base64.getEncoder().encodeToString((username + ":" + accessKey).getBytes());
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new Jdk8Module());
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper = objectMapper;
    }

    public <D> D execute(GraphQLOperation operation, Class<D> responseType) throws VisualApiException {
        try {
            HttpPost request = new HttpPost(this.uri);
            request.setHeader("Content-Type", "application/json");
            request.setHeader("Accept", "application/json");
            request.setHeader("Authorization", "Basic " + this.authentication);
            request.setHeader("User-Agent", "sauce-visual-java/" + ArtifactVersion.getArtifactVersion().orElse("unknown"));
            String requestBody = this.objectMapper.writeValueAsString((Object)operation);
            request.setEntity((HttpEntity)new StringEntity(requestBody));
            HttpResponse response = this.client.execute((HttpUriRequest)request);
            HttpEntity entity = response.getEntity();
            int status = response.getStatusLine().getStatusCode();
            String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            if (status < 200 || status >= 300) {
                throw new VisualApiException("Unexpected status code: " + status + " " + responseString);
            }
            JsonNode rootNode = this.objectMapper.readTree(responseString);
            JsonNode dataField = rootNode.get("data");
            return (D)this.objectMapper.treeToValue((TreeNode)dataField, responseType);
        }
        catch (IOException e) {
            throw new VisualApiException("error while executing request", e);
        }
    }
}

