/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.visual;

import com.saucelabs.visual.Options;
import com.saucelabs.visual.Region;
import com.saucelabs.visual.VisualBuild;
import com.saucelabs.visual.exception.VisualApiException;
import com.saucelabs.visual.graphql.type.BuildIn;
import com.saucelabs.visual.graphql.type.CreateSnapshotFromWebDriverIn;
import com.saucelabs.visual.graphql.type.FinishBuildIn;
import com.saucelabs.visual.graphql.type.RegionIn;
import com.saucelabs.visual.graphql.type.WebdriverSessionInfoIn;
import com.saucelabs.visual.graphqloperation.CreateBuildMutation;
import com.saucelabs.visual.graphqloperation.FinishBuildMutation;
import com.saucelabs.visual.graphqloperation.WebdriverSessionInfoQuery;
import com.saucelabs.visual.model.IgnoreRegion;
import com.saucelabs.visual.utils.ConsoleColors;
import com.saucelabs.visual.utils.GraphQLClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualApi {
    private static final Logger log = LoggerFactory.getLogger(VisualApi.class);
    private final GraphQLClient client;
    private final String sessionMetadataBlob;
    private final String buildId;
    private final String jobId;
    private final String sessionId;

    public VisualApi(RemoteWebDriver driver, Region region, String username, String accessKey) {
        this(driver, region.endpoint, username, accessKey);
    }

    public VisualApi(RemoteWebDriver driver, String url, String username, String accessKey) {
        this(driver, url, username, accessKey, new BuildAttributes(null, null, null));
    }

    public VisualApi(RemoteWebDriver driver, String url, String username, String accessKey, BuildAttributes buildAttributes) {
        if (username == null || accessKey == null || username.trim().isEmpty() || accessKey.trim().isEmpty()) {
            throw new VisualApiException("Invalid SauceLabs credentials. Please check your SauceLabs username and access key at https://app.saucelabs.com/user-settings");
        }
        this.client = new GraphQLClient(url, username, accessKey);
        this.sessionId = driver.getSessionId().toString();
        String jobIdString = (String)driver.getCapabilities().getCapability("jobUuid");
        this.jobId = jobIdString == null ? this.sessionId : jobIdString;
        this.buildId = VisualBuild.getOnce(this, buildAttributes);
        this.sessionMetadataBlob = this.webdriverSessionInfo().blob;
    }

    VisualApi(String jobId, String sessionId, String buildId, String sessionMetadataBlob, String url, String username, String accessKey) {
        if (username == null || accessKey == null || username.trim().isEmpty() || accessKey.trim().isEmpty()) {
            throw new VisualApiException("Invalid SauceLabs credentials. Please check your SauceLabs username and access key at https://app.saucelabs.com/user-settings");
        }
        this.buildId = buildId;
        this.jobId = jobId;
        this.sessionId = sessionId;
        this.client = new GraphQLClient(url, username, accessKey);
        this.sessionMetadataBlob = sessionMetadataBlob;
    }

    private WebdriverSessionInfoQuery.Result webdriverSessionInfo() {
        WebdriverSessionInfoIn input = WebdriverSessionInfoIn.builder().jobId(this.jobId).sessionId(this.sessionId).build();
        return ((WebdriverSessionInfoQuery.Data)this.client.execute(new WebdriverSessionInfoQuery((WebdriverSessionInfoIn)input))).result;
    }

    private static String getStartupMessage(String url) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append("\n").append(ConsoleColors.Bold(ConsoleColors.Yellow("Sauce Visual\n"))).append("\n").append(String.format("%100s\n", url)).append("\n");
        return sb.toString();
    }

    String createBuild(String buildName) {
        return this.createBuild(new BuildAttributes(buildName, null, null));
    }

    String createBuild(BuildAttributes buildAttributes) {
        BuildIn input = BuildIn.builder().name(buildAttributes.getName()).project(buildAttributes.getProject()).branch(buildAttributes.getBranch()).build();
        CreateBuildMutation mutation = new CreateBuildMutation(input);
        CreateBuildMutation.Data data = (CreateBuildMutation.Data)this.client.execute(mutation);
        log.info(VisualApi.getStartupMessage(data.result.url));
        return data.result.id;
    }

    FinishBuildMutation.Result finishBuild(String buildId) {
        FinishBuildIn input = FinishBuildIn.builder().id(buildId).build();
        FinishBuildMutation mutation = new FinishBuildMutation(input);
        return ((FinishBuildMutation.Data)this.client.execute(mutation)).result;
    }

    public void check(String name) {
        Options options = new Options();
        this.check(name, options);
    }

    public void check(String name, Options options) {
        CreateSnapshotFromWebDriverIn input = CreateSnapshotFromWebDriverIn.builder().sessionId(this.sessionId).name(name).buildId(this.buildId).ignoreRegions(this.extractIgnoreList(options)).sessionMetadata(this.sessionMetadataBlob).build();
        this.client.check(input);
    }

    private List<RegionIn> extractIgnoreList(Options options) {
        int i;
        if (options == null) {
            return Collections.emptyList();
        }
        ArrayList<RegionIn> result = new ArrayList<RegionIn>();
        for (i = 0; i < options.getIgnoreElements().size(); ++i) {
            WebElement element = options.getIgnoreElements().get(i);
            if (this.validate(element) == null) {
                throw new VisualApiException("options.ignoreElement[" + i + "] does not exist (yet)");
            }
            result.add(this.toIgnoreIn(element));
        }
        for (i = 0; i < options.getIgnoreRegions().size(); ++i) {
            IgnoreRegion ignoreRegion = options.getIgnoreRegions().get(i);
            if (this.validate(ignoreRegion) == null) {
                throw new VisualApiException("options.ignoreRegion[" + i + "] is an invalid ignore region");
            }
            result.add(this.toIgnoreIn(ignoreRegion));
        }
        return result;
    }

    private RegionIn toIgnoreIn(WebElement element) {
        Rectangle r = element.getRect();
        return RegionIn.builder().x(r.getX()).y(r.getY()).width(r.getWidth()).height(r.getHeight()).build();
    }

    private RegionIn toIgnoreIn(IgnoreRegion r) {
        return RegionIn.builder().x(r.getX()).y(r.getY()).width(r.getWidth()).height(r.getHeight()).build();
    }

    private WebElement validate(WebElement element) {
        if (element == null || !element.isDisplayed() || element.getRect() == null) {
            return null;
        }
        return element;
    }

    private IgnoreRegion validate(IgnoreRegion region) {
        if (region == null || region.getHeight() == null || region.getWidth() == null || region.getX() == null || region.getY() == null) {
            return null;
        }
        if (region.getHeight() <= 0 || region.getWidth() <= 0) {
            return null;
        }
        return region;
    }

    String getBuildId() {
        return this.buildId;
    }

    public static class BuildAttributes {
        private final String name;
        private final String project;
        private final String branch;

        public BuildAttributes(String name, String project, String branch) {
            this.name = name;
            this.project = project;
            this.branch = branch;
        }

        public String getName() {
            return this.name;
        }

        public String getProject() {
            return this.project;
        }

        public String getBranch() {
            return this.branch;
        }
    }

    public static class Builder {
        private final RemoteWebDriver driver;
        private final String username;
        private final String accessKey;
        private final String endpoint;
        private String projectName;
        private String branchName;
        private String buildName;

        public Builder(RemoteWebDriver driver, String username, String accessKey) {
            this(driver, username, accessKey, Region.US_WEST_1.endpoint);
        }

        public Builder(RemoteWebDriver driver, String username, String accessKey, Region region) {
            this(driver, username, accessKey, region.endpoint);
        }

        public Builder(RemoteWebDriver driver, String username, String accessKey, String endpoint) {
            this.driver = driver;
            this.username = username;
            this.accessKey = accessKey;
            this.endpoint = endpoint;
        }

        public Builder withBuild(String buildName) {
            this.buildName = buildName;
            return this;
        }

        public Builder withProject(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public Builder withBranch(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public VisualApi build() {
            if (this.buildName == null) {
                this.buildName = System.getenv("BUILD_NAME");
            }
            return new VisualApi(this.driver, this.endpoint, this.username, this.accessKey, new BuildAttributes(this.buildName, this.projectName, this.branchName));
        }
    }
}

