/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.visual.utils;

import com.apollographql.apollo3.api.CustomScalarAdapters;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.Operations;
import com.apollographql.apollo3.api.json.BufferedSinkJsonWriter;
import com.apollographql.apollo3.api.json.JsonWriter;
import com.saucelabs.visual.exception.VisualApiException;
import com.saucelabs.visual.graphql.type.BuildIn;
import com.saucelabs.visual.graphql.type.CreateSnapshotFromWebDriverIn;
import com.saucelabs.visual.graphql.type.FinishBuildIn;
import com.saucelabs.visual.graphql.type.WebdriverSessionInfoIn;
import com.saucelabs.visual.graphqloperation.CreateBuildMutation;
import com.saucelabs.visual.graphqloperation.CreateSnapshotFromWebDriverMutation;
import com.saucelabs.visual.graphqloperation.FinishBuildMutation;
import com.saucelabs.visual.graphqloperation.WebdriverSessionInfoQuery;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Base64;
import okio.Buffer;
import okio.BufferedSink;

public class GraphQLClient {
    private final String uri;
    private final HttpClient client;
    private final String authentication;

    public GraphQLClient(String uri, String username, String accessKey) {
        this.uri = uri;
        this.client = HttpClient.newBuilder().build();
        this.authentication = Base64.getEncoder().encodeToString((username + ":" + accessKey).getBytes());
    }

    WebdriverSessionInfoQuery.Result webdriverSessionInfo(WebdriverSessionInfoIn input) {
        return ((WebdriverSessionInfoQuery.Data)this.execute(new WebdriverSessionInfoQuery((WebdriverSessionInfoIn)input))).result;
    }

    CreateBuildMutation.Result createBuild(BuildIn input) {
        CreateBuildMutation mutation = new CreateBuildMutation(input);
        CreateBuildMutation.Data data = (CreateBuildMutation.Data)this.execute((Operation)mutation);
        return data.result;
    }

    FinishBuildMutation.Result finishBuild(FinishBuildIn input) {
        FinishBuildMutation mutation = new FinishBuildMutation(input);
        FinishBuildMutation.Data data = (FinishBuildMutation.Data)this.execute((Operation)mutation);
        return data.result;
    }

    public CreateSnapshotFromWebDriverMutation.Result check(CreateSnapshotFromWebDriverIn input) {
        CreateSnapshotFromWebDriverMutation mutation = new CreateSnapshotFromWebDriverMutation(input);
        return ((CreateSnapshotFromWebDriverMutation.Data)this.execute(mutation)).result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <D extends Operation.Data> D execute(Operation<D> operation) {
        try (Buffer buffer = new Buffer();){
            BufferedSinkJsonWriter jsonWriter = new BufferedSinkJsonWriter((BufferedSink)buffer, "  ");
            Operations.composeJsonRequest(operation, (JsonWriter)jsonWriter, (CustomScalarAdapters)CustomScalarAdapters.Empty);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.uri)).header("Content-Type", "application/json").header("Accept", "application/json").header("Authorization", "Basic " + this.authentication).POST(HttpRequest.BodyPublishers.ofString(buffer.readUtf8())).build();
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() < 200) throw new VisualApiException("Unexpected status code: " + response.statusCode() + " " + response.body());
            if (response.statusCode() >= 300) {
                throw new VisualApiException("Unexpected status code: " + response.statusCode() + " " + response.body());
            }
            Operation.Data data = Operations.parseJsonResponse(operation, (String)response.body(), (CustomScalarAdapters)CustomScalarAdapters.Empty).dataAssertNoErrors();
            return (D)data;
        }
        catch (IOException | InterruptedException e) {
            throw new VisualApiException("Error while executing GraqpQL request", e);
        }
    }
}

