/*
 * Decompiled with CFR 0.152.
 */
package com.savoirtech.logging.slf4j.json.logger;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.savoirtech.logging.slf4j.json.logger.JsonLogger;
import java.text.Format;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.MDC;

public abstract class AbstractJsonLogger
implements JsonLogger {
    protected Logger slf4jLogger;
    private FastDateFormat formatter;
    private Gson gson;
    private JsonObject jsonObject;

    public AbstractJsonLogger(Logger slf4jLogger, FastDateFormat formatter, Gson gson) {
        this.slf4jLogger = slf4jLogger;
        this.formatter = formatter;
        this.gson = gson;
        this.jsonObject = new JsonObject();
    }

    @Override
    public JsonLogger message(String message) {
        try {
            this.jsonObject.add("message", this.gson.toJsonTree((Object)message));
        }
        catch (Exception e) {
            this.jsonObject.add("message", this.gson.toJsonTree((Object)this.formatException(e)));
        }
        return this;
    }

    @Override
    public JsonLogger message(Supplier<String> message) {
        try {
            this.jsonObject.add("message", this.gson.toJsonTree((Object)message.get()));
        }
        catch (Exception e) {
            this.jsonObject.add("message", this.gson.toJsonTree((Object)this.formatException(e)));
        }
        return this;
    }

    @Override
    public JsonLogger map(String key, Map map) {
        try {
            this.jsonObject.add(key, this.gson.toJsonTree((Object)map));
        }
        catch (Exception e) {
            this.jsonObject.add(key, this.gson.toJsonTree((Object)this.formatException(e)));
        }
        return this;
    }

    @Override
    public JsonLogger map(String key, Supplier<Map> map) {
        try {
            this.jsonObject.add(key, this.gson.toJsonTree((Object)map.get()));
        }
        catch (Exception e) {
            this.jsonObject.add(key, this.gson.toJsonTree((Object)this.formatException(e)));
        }
        return this;
    }

    @Override
    public JsonLogger list(String key, List list) {
        try {
            this.jsonObject.add(key, this.gson.toJsonTree((Object)list));
        }
        catch (Exception e) {
            this.jsonObject.add(key, this.gson.toJsonTree((Object)this.formatException(e)));
        }
        return this;
    }

    @Override
    public JsonLogger list(String key, Supplier<List> list) {
        try {
            this.jsonObject.add(key, this.gson.toJsonTree((Object)list.get()));
        }
        catch (Exception e) {
            this.jsonObject.add(key, this.gson.toJsonTree((Object)this.formatException(e)));
        }
        return this;
    }

    @Override
    public JsonLogger field(String key, String value) {
        try {
            this.jsonObject.add(key, this.gson.toJsonTree((Object)value));
        }
        catch (Exception e) {
            this.jsonObject.add(key, this.gson.toJsonTree((Object)this.formatException(e)));
        }
        return this;
    }

    @Override
    public JsonLogger field(String key, Supplier<String> value) {
        try {
            this.jsonObject.add(key, this.gson.toJsonTree((Object)value.get()));
        }
        catch (Exception e) {
            this.jsonObject.add(key, this.gson.toJsonTree((Object)this.formatException(e)));
        }
        return this;
    }

    @Override
    public JsonLogger json(String key, JsonElement jsonElement) {
        try {
            this.jsonObject.add(key, jsonElement);
        }
        catch (Exception e) {
            this.jsonObject.add(key, this.gson.toJsonTree((Object)this.formatException(e)));
        }
        return this;
    }

    @Override
    public JsonLogger json(String key, Supplier<JsonElement> jsonElement) {
        try {
            this.jsonObject.add(key, jsonElement.get());
        }
        catch (Exception e) {
            this.jsonObject.add(key, this.gson.toJsonTree((Object)this.formatException(e)));
        }
        return this;
    }

    @Override
    public JsonLogger exception(String key, Exception exception) {
        try {
            this.jsonObject.add(key, this.gson.toJsonTree((Object)this.formatException(exception)));
        }
        catch (Exception e) {
            this.jsonObject.add(key, this.gson.toJsonTree((Object)this.formatException(e)));
        }
        return this;
    }

    @Override
    public abstract void log();

    protected String formatMessage(String level) {
        this.jsonObject.add("level", this.gson.toJsonTree((Object)level));
        try {
            this.jsonObject.add("timestamp", this.gson.toJsonTree((Object)this.getCurrentTimestamp((Format)this.formatter)));
        }
        catch (Exception e) {
            this.jsonObject.add("timestamp", this.gson.toJsonTree((Object)this.formatException(e)));
        }
        Map mdc = MDC.getCopyOfContextMap();
        if (mdc != null && !mdc.isEmpty()) {
            try {
                this.jsonObject.add("MDC", this.gson.toJsonTree((Object)mdc));
            }
            catch (Exception e) {
                this.jsonObject.add("MDC", this.gson.toJsonTree((Object)this.formatException(e)));
            }
        }
        return this.gson.toJson((JsonElement)this.jsonObject);
    }

    private String getCurrentTimestamp(Format formatter) {
        return formatter.format(System.currentTimeMillis());
    }

    private String formatException(Exception e) {
        return ExceptionUtils.getStackTrace((Throwable)e);
    }
}

