/*
 * Decompiled with CFR 0.152.
 */
package com.savoirtech.logging.slf4j.json.logger;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.savoirtech.logging.slf4j.json.logger.DebugLogger;
import com.savoirtech.logging.slf4j.json.logger.ErrorLogger;
import com.savoirtech.logging.slf4j.json.logger.InfoLogger;
import com.savoirtech.logging.slf4j.json.logger.JsonLogger;
import com.savoirtech.logging.slf4j.json.logger.NoopLogger;
import com.savoirtech.logging.slf4j.json.logger.TraceLogger;
import com.savoirtech.logging.slf4j.json.logger.WarnLogger;
import org.apache.commons.lang3.time.FastDateFormat;

public class Logger {
    private org.slf4j.Logger slf4jLogger;
    private Gson gson = new GsonBuilder().disableHtmlEscaping().serializeNulls().create();
    private FastDateFormat formatter;
    private boolean includeLoggerName;
    private NoopLogger noopLogger = new NoopLogger();

    public Logger(org.slf4j.Logger slf4jLogger, FastDateFormat formatter, boolean includeLoggerName) {
        this.slf4jLogger = slf4jLogger;
        this.formatter = formatter;
        this.includeLoggerName = includeLoggerName;
    }

    public JsonLogger trace() {
        if (this.slf4jLogger.isTraceEnabled()) {
            return new TraceLogger(this.slf4jLogger, this.formatter, this.gson, this.includeLoggerName);
        }
        return this.noopLogger;
    }

    public JsonLogger debug() {
        if (this.slf4jLogger.isDebugEnabled()) {
            return new DebugLogger(this.slf4jLogger, this.formatter, this.gson, this.includeLoggerName);
        }
        return this.noopLogger;
    }

    public JsonLogger info() {
        if (this.slf4jLogger.isInfoEnabled()) {
            return new InfoLogger(this.slf4jLogger, this.formatter, this.gson, this.includeLoggerName);
        }
        return this.noopLogger;
    }

    public JsonLogger warn() {
        if (this.slf4jLogger.isWarnEnabled()) {
            return new WarnLogger(this.slf4jLogger, this.formatter, this.gson, this.includeLoggerName);
        }
        return this.noopLogger;
    }

    public JsonLogger error() {
        if (this.slf4jLogger.isErrorEnabled()) {
            return new ErrorLogger(this.slf4jLogger, this.formatter, this.gson, this.includeLoggerName);
        }
        return this.noopLogger;
    }
}

